/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial.type;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.type.ShapeSerializers;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.util.Utils;

public class ShapeDataType
extends BasicDataType<Shape> {
    private final Object2IntOpenHashMap<Class<?>> averageSizes = new Object2IntOpenHashMap();

    public static byte[] writeCompressed(CompoundTag compoundTag) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(byteArrayOutputStream));){
            NbtIo.m_128941_((CompoundTag)compoundTag, (DataOutput)dataoutputstream);
        }
        catch (IOException e) {
            return Utils.EMPTY_BYTES;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static CompoundTag readCompressed(byte[] bytes) {
        CompoundTag compoundTag;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        DataInputStream inputStream = new DataInputStream(new GZIPInputStream(byteArrayInputStream));
        try {
            compoundTag = NbtIo.m_128934_((DataInput)inputStream, (NbtAccounter)NbtAccounter.f_128917_);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new CompoundTag();
            }
        }
        inputStream.close();
        return compoundTag;
    }

    public int getMemory(Shape shape) {
        return this.averageSizes.getOrDefault(shape.getClass(), 1000);
    }

    private void computeAverageSize(Shape shape, byte[] data) {
        int averageSize = this.averageSizes.getOrDefault(shape.getClass(), 1000);
        int size = data.length * 2;
        long n = 15L;
        averageSize = (int)(((long)size + n * (long)averageSize) / (n + 1L));
        this.averageSizes.put(shape.getClass(), averageSize);
    }

    public void write(WriteBuffer buffer, Shape shape) {
        if (shape == Shape.EMPTY) {
            buffer.putVarInt(0);
            return;
        }
        NBTSerializer<Shape> serializer = shape.getNBTSerializer();
        CompoundTag nbt = serializer.write(shape);
        nbt.m_128359_("Serializer", serializer.id());
        byte[] data = ShapeDataType.writeCompressed(nbt);
        buffer.putVarInt(data.length);
        if (data.length > 0) {
            buffer.put(data);
            this.computeAverageSize(shape, data);
        }
    }

    public Shape read(ByteBuffer buffer) {
        int length = DataUtils.readVarInt((ByteBuffer)buffer);
        if (length > 0) {
            byte[] data = new byte[length];
            buffer.get(data);
            CompoundTag nbt = ShapeDataType.readCompressed(data);
            String serializerId = nbt.m_128461_("Serializer");
            NBTSerializer<Shape> serializer = ShapeSerializers.get(serializerId);
            if (serializer != null) {
                Shape shape = serializer.read(nbt);
                this.computeAverageSize(shape, data);
                return shape;
            }
        }
        return Shape.EMPTY;
    }

    public Shape[] createStorage(int size) {
        return new Shape[size];
    }
}

