/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.world.spatial.SpatialKey;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.type.ShapeDataType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.MarkerManager;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.Spatial;
import org.h2.mvstore.type.DataType;

public final class SpatialShapeStorage
extends SavedData
implements AutoCloseable {
    public static final String LOG_MARKER = "SpatialStore";
    public static final LevelResource DATA_DIR = new LevelResource("data");
    private final MVStore store;
    private final Map<String, MVRTreeMap<Long>> levelTrees = new HashMap<String, MVRTreeMap<Long>>();
    private final Map<String, MVMap<Long, Shape>> levelShapes = new HashMap<String, MVMap<Long, Shape>>();

    private SpatialShapeStorage(String filePath) {
        this.store = new MVStore.Builder().fileName(filePath).cacheSize(8).open();
        BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), "initialized Store using file {}", (Object)filePath);
    }

    private static SpatialShapeStorage load(CompoundTag tag, String path) {
        return new SpatialShapeStorage(path);
    }

    public static SpatialShapeStorage getInstance(ServerLevel level) {
        String path = level.m_7654_().m_129843_(DATA_DIR).resolve("biomancy.spatial.db").toFile().getPath();
        return (SpatialShapeStorage)level.m_7654_().m_129783_().m_8895_().m_164861_(tag -> SpatialShapeStorage.load(tag, path), () -> new SpatialShapeStorage(path), "biomancy.spatial");
    }

    @Override
    public void close() {
        this.levelTrees.clear();
        this.levelShapes.clear();
        BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), "Persisting pending changes and compacting the store");
        this.store.close(250);
    }

    MVRTreeMap<Long> getTree(String levelKey) {
        return this.levelTrees.computeIfAbsent(levelKey, this::createTreeForLevel);
    }

    MVMap<Long, Shape> getShapes(String levelKey) {
        return this.levelShapes.computeIfAbsent(levelKey, this::createMapForLevel);
    }

    private MVRTreeMap<Long> createTreeForLevel(String levelKey) {
        MVRTreeMap.Builder builder = new MVRTreeMap.Builder().dimensions(3);
        MVRTreeMap tree = (MVRTreeMap)this.store.openMap(levelKey + "_rtree", (MVMap.MapBuilder)builder);
        if (!tree.isQuadraticSplit()) {
            tree.setQuadraticSplit(true);
        }
        return tree;
    }

    private MVMap<Long, Shape> createMapForLevel(String levelKey) {
        MVMap.Builder builder = new MVMap.Builder().valueType((DataType)new ShapeDataType());
        return this.store.openMap(levelKey + "_shapes", (MVMap.MapBuilder)builder);
    }

    public MVRTreeMap.RTreeCursor<Long> findIntersecting(String levelKey, Spatial boundingBox) {
        return this.getTree(levelKey).findIntersectingKeys(boundingBox);
    }

    public MVRTreeMap.RTreeCursor<Long> findContained(String levelKey, Spatial boundingBox) {
        return this.getTree(levelKey).findContainedKeys(boundingBox);
    }

    public Shape getOrCreate(String levelKey, long shapeId, Supplier<Shape> factory) {
        MVRTreeMap<Long> tree = this.getTree(levelKey);
        MVMap<Long, Shape> shapes = this.getShapes(levelKey);
        if (shapes.containsKey((Object)shapeId)) {
            Shape shape = (Shape)shapes.get((Object)shapeId);
            BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), "Fetched existing id={} shape={}", (Object)shapeId, (Object)shape);
            return shape;
        }
        Shape shape = factory.get();
        shapes.put((Object)shapeId, (Object)shape);
        tree.add((Spatial)new SpatialKey(shapeId, shape.getAABB()), (Object)shapeId);
        BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), "Created id={} shape={}", (Object)shapeId, (Object)shape);
        this.m_77762_();
        return shape;
    }

    public void remove(String levelKey, long shapeId) {
        MVMap<Long, Shape> shapes = this.getShapes(levelKey);
        MVRTreeMap<Long> tree = this.getTree(levelKey);
        Shape shape = (Shape)shapes.get((Object)shapeId);
        if (shape == null) {
            return;
        }
        Long removed = (Long)tree.remove((Object)new SpatialKey(shapeId, shape.getAABB()));
        shapes.remove((Object)shapeId);
        BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), "Removed id={} shape={}", (Object)removed, (Object)shape);
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        return tag;
    }

    public void m_77757_(File file) {
        super.m_77757_(file);
        if (!this.store.isClosed()) {
            if (this.store.hasUnsavedChanges()) {
                long version = this.store.commit();
                if (BiomancyMod.LOGGER.isDebugEnabled()) {
                    String message = version >= 0L ? "Flushed all changes to disk" : "Failed to flush changes";
                    BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), message);
                }
            } else {
                BiomancyMod.LOGGER.debug(MarkerManager.getMarker((String)LOG_MARKER), "Found no changes to flush to disk");
            }
        }
    }
}

