/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound.decorator;

import com.github.elenterius.biomancy.world.mound.Chamber;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface ChamberDecorator {
    public PartOfDecorationResult isBlockPartOfDecoration(Chamber var1, Level var2, BlockPos var3, BlockState var4);

    public boolean canPlace(Chamber var1, Level var2, BlockPos var3, Direction var4);

    public boolean place(Chamber var1, Level var2, BlockPos var3, Direction var4);

    public static enum PartOfDecorationResult {
        POSITION_AND_MATERIAL_ARE_VALID(true, true),
        POSITION_AND_MATERIAL_ARE_INVALID(false, false),
        POSITION_IS_VALID_AND_MATERIAL_IS_INVALID(true, false),
        POSITION_IS_INVALID_AND_MATERIAL_IS_VALID(false, true);

        static final PartOfDecorationResult[] sortedValues;
        public final boolean positionIsValid;
        public final boolean materialIsValid;

        private PartOfDecorationResult(boolean positionIsValid, boolean materialIsValid) {
            this.positionIsValid = positionIsValid;
            this.materialIsValid = materialIsValid;
        }

        public int index() {
            return PartOfDecorationResult.getIndex(this.positionIsValid, this.materialIsValid);
        }

        public static PartOfDecorationResult of(boolean positionValid, boolean materialValid) {
            int index = PartOfDecorationResult.getIndex(positionValid, materialValid);
            return sortedValues[index];
        }

        private static int getIndex(boolean positionValid, boolean materialValid) {
            return (positionValid ? 1 : 0) << 1 | (materialValid ? 1 : 0);
        }

        static {
            sortedValues = new PartOfDecorationResult[PartOfDecorationResult.values().length];
            for (PartOfDecorationResult result : PartOfDecorationResult.values()) {
                int index = PartOfDecorationResult.getIndex(result.positionIsValid, result.materialIsValid);
                PartOfDecorationResult.sortedValues[index] = result;
            }
        }
    }
}

