/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.mound.Chamber;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberDecorator;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberDecorators;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MoundChamber
implements Chamber {
    private final Shape shape;
    private final Vec3 origin;
    private int seed = 1337;
    private ChamberDecorator chamberDecorator = ChamberDecorators.EMPTY;

    public MoundChamber(Vec3 origin, Shape shape) {
        this.shape = shape;
        this.origin = origin;
    }

    public MoundChamber(Shape shape) {
        this.shape = shape;
        this.origin = shape.center();
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.shape.contains(x, y, z);
    }

    @Override
    public boolean intersectsCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.shape.intersectsCuboid(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public Vec3 center() {
        return this.shape.center();
    }

    @Override
    public int seed() {
        return this.seed;
    }

    public void setDecorator(ChamberDecorator chamberDecorator, int seed) {
        this.chamberDecorator = chamberDecorator;
        this.seed = seed;
    }

    @Override
    public ChamberDecorator getDecorator() {
        return this.chamberDecorator;
    }

    @Override
    public Vec3 origin() {
        return this.origin;
    }

    @Override
    public double distanceToSqr(double x, double y, double z) {
        return this.shape.distanceToSqr(x, y, z);
    }

    @Override
    public AABB getAABB() {
        return this.shape.getAABB();
    }

    @Override
    public NBTSerializer<Shape> getNBTSerializer() {
        return null;
    }
}

