/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.random;

import com.github.elenterius.biomancy.util.random.DynamicWeightedRandomList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DynamicLootTable
extends DynamicWeightedRandomList<DynamicWeightedRandomList.IWeightedEntry<ItemLoot>> {
    public static final ToIntBiFunction<RandomSource, Integer> CONSTANT_ITEM_AMOUNT_FUNC = (random, lootingLevel) -> 1;
    public static final ToIntBiFunction<RandomSource, Integer> RANDOM_ITEM_AMOUNT_FUNC_1 = (random, lootingLevel) -> Mth.m_216271_((RandomSource)random, (int)1, (int)(1 + lootingLevel));
    public static final ToIntBiFunction<RandomSource, Integer> RANDOM_ITEM_AMOUNT_FUNC_2 = (random, lootingLevel) -> Mth.m_216271_((RandomSource)random, (int)1, (int)(2 + lootingLevel));

    public void add(ItemLoot loot, int weight) {
        super.addEntry(new DynamicWeightedRandomList.IWeightedEntry.Default<ItemLoot>(loot, weight));
    }

    public void addSelfRemoving(ItemLoot loot, int weight) {
        super.addEntry(new DynamicWeightedRandomList.IWeightedEntry.SelfRemoving<ItemLoot>(loot, weight));
    }

    public Optional<ItemLoot> getRandomItem(RandomSource random) {
        return this.getRandom(random).map(DynamicWeightedRandomList.IWeightedEntry::data);
    }

    public Optional<ItemLoot> getAndRemoveRandomItem(RandomSource random) {
        Optional<DynamicWeightedRandomList.IWeightedEntry> weightedEntry = this.getRandom(random);
        weightedEntry.ifPresent(this::removeEntry);
        return weightedEntry.map(DynamicWeightedRandomList.IWeightedEntry::data);
    }

    public Optional<ItemStack> getRandomItemStack(RandomSource random, int lootingLevel) {
        return this.getRandomItem(random).map(itemLoot -> itemLoot.getItemStack(random, lootingLevel));
    }

    public record ItemLoot(Supplier<? extends Item> itemSupplier, ToIntBiFunction<RandomSource, Integer> itemCountFunc) {
        public int getItemAmount(RandomSource random, int lootingLevel) {
            return this.itemCountFunc.applyAsInt(random, lootingLevel);
        }

        public ItemStack getItemStack(RandomSource random, int lootingLevel) {
            return new ItemStack((ItemLike)this.itemSupplier.get(), this.getItemAmount(random, lootingLevel));
        }
    }
}

