/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.permission;

import com.github.elenterius.biomancy.util.permission.UserType;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class UserAuthorization
implements INBTSerializable<CompoundTag> {
    private UUID userUUID;
    private UserType authority;

    public UserAuthorization(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public UserAuthorization(UUID userUUID) {
        this(userUUID, UserType.DEFAULT);
    }

    public UserAuthorization(UUID userUUID, UserType type) {
        this.userUUID = userUUID;
        this.authority = type;
    }

    public UUID getUser() {
        return this.userUUID;
    }

    public UserType getAuthority() {
        return this.authority;
    }

    public void setAuthorityLevel(UserType level) {
        this.authority = level;
    }

    public int getAuthorityLevel() {
        return this.authority.getAccessLevel();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("UserUUID", this.userUUID);
        this.authority.serialize(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.userUUID = nbt.m_128342_("UserUUID");
        this.authority = UserType.deserialize(nbt);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserAuthorization) {
            UserAuthorization other = (UserAuthorization)obj;
            return this.userUUID.equals(other.userUUID) && this.authority == other.authority;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userUUID, this.authority});
    }

    public String toString() {
        return "(" + this.userUUID.toString() + "," + this.authority + ")";
    }
}

