/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.colors;

import net.minecraft.util.FastColor;

public final class ColorSpace {
    private ColorSpace() {
    }

    private static double cube(double x) {
        return x * x * x;
    }

    public static final class OkLCh {
        private OkLCh() {
        }

        public static double[] fromLinearSRGB(double rLinear, double gLinear, double bLinear) {
            double[] Lab = OkLab.fromLinearSRGB(rLinear, gLinear, bLinear);
            double Lightness = Lab[0];
            double a = Lab[1];
            double b = Lab[2];
            double Chroma = Math.sqrt(a * a + b * b);
            double hue = Math.atan2(b, a);
            return new double[]{Lightness, Chroma, hue};
        }

        public static double[] fromSRGB(double r, double g, double b) {
            return OkLCh.fromLinearSRGB(SRGB.toLinear(r), SRGB.toLinear(g), SRGB.toLinear(b));
        }

        public static double[] fromSRGB(double[] rgb) {
            return OkLCh.fromSRGB(rgb[0], rgb[1], rgb[2]);
        }

        public static double[] fromARGB32(int rgb) {
            return OkLCh.fromSRGB(SRGB.fromARGB32(rgb));
        }

        public static double[] toLinearSRGB(double[] LCh) {
            return OkLab.toLinearSRGB(OkLCh.toOkLab(LCh));
        }

        public static double[] toSRGB(double[] LCh) {
            double[] linearRGB = OkLCh.toLinearSRGB(LCh);
            return SRGB.fromLinear(linearRGB);
        }

        public static int toARGB32(double[] LCh) {
            return SRGB.toARGB32(OkLCh.toSRGB(LCh));
        }

        public static double[] toOkLab(double[] LCh) {
            double Lightness = LCh[0];
            double Chroma = LCh[1];
            double hue = Math.toRadians(LCh[2]);
            double a = Chroma * Math.cos(hue);
            double b = Chroma * Math.sin(hue);
            return new double[]{Lightness, a, b};
        }
    }

    public static final class OkLab {
        private OkLab() {
        }

        public static double[] fromLinearSRGB(double rLinear, double gLinear, double bLinear) {
            double cubeRootL = Math.cbrt(0.4122214708 * rLinear + 0.5363325363 * gLinear + 0.0514459929 * bLinear);
            double cubeRootM = Math.cbrt(0.2119034982 * rLinear + 0.6806995451 * gLinear + 0.1073969566 * bLinear);
            double cubeRootS = Math.cbrt(0.0883024619 * rLinear + 0.2817188376 * gLinear + 0.6299787005 * bLinear);
            double L = 0.2104542553 * cubeRootL + 0.793617785 * cubeRootM - 0.0040720468 * cubeRootS;
            double a = 1.9779984951 * cubeRootL - 2.428592205 * cubeRootM + 0.4505937099 * cubeRootS;
            double b = 0.0259040371 * cubeRootL + 0.7827717662 * cubeRootM - 0.808675766 * cubeRootS;
            return new double[]{L, a, b};
        }

        public static double[] fromSRGB(double r, double g, double b) {
            return OkLab.fromLinearSRGB(SRGB.toLinear(r), SRGB.toLinear(g), SRGB.toLinear(b));
        }

        public static double[] fromSRGB(double[] rgb) {
            return OkLab.fromSRGB(rgb[0], rgb[1], rgb[2]);
        }

        public static double[] fromARGB32(int rgb) {
            return OkLab.fromSRGB(SRGB.fromARGB32(rgb));
        }

        public static double[] toLinearSRGB(double[] Lab) {
            double Lightness = Lab[0];
            double a = Lab[1];
            double b = Lab[2];
            double l = ColorSpace.cube(Lightness + 0.3963377774 * a + 0.2158037573 * b);
            double m = ColorSpace.cube(Lightness - 0.1055613458 * a - 0.0638541728 * b);
            double s = ColorSpace.cube(Lightness - 0.0894841775 * a - 1.291485548 * b);
            return new double[]{4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s, -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s, -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s};
        }

        public static double[] toSRGB(double[] Lab) {
            double[] linearRGB = OkLab.toLinearSRGB(Lab);
            return SRGB.fromLinear(linearRGB);
        }

        public static int toARGB32(double[] LCh) {
            return SRGB.toARGB32(OkLab.toSRGB(LCh));
        }

        public static double[] toOkLCh(double[] Lab) {
            double Lightness = Lab[0];
            double a = Lab[1];
            double b = Lab[2];
            double Chroma = Math.sqrt(a * a + b * b);
            double hue = Math.atan2(b, a);
            return new double[]{Lightness, Chroma, hue};
        }
    }

    public static final class SRGB {
        private SRGB() {
        }

        public static double toLinear(double colorChannel) {
            if (colorChannel < 0.04045) {
                return colorChannel / 12.92;
            }
            return Math.pow((colorChannel + 0.055) / 1.055, 2.4);
        }

        public static double[] toLinear(double[] rgb) {
            return new double[]{SRGB.toLinear(rgb[0]), SRGB.toLinear(rgb[1]), SRGB.toLinear(rgb[2])};
        }

        public static double fromLinear(double colorChannel) {
            if (colorChannel < 0.0031308) {
                return 12.92 * colorChannel;
            }
            return 1.055 * Math.pow(colorChannel, 0.4166666666666667) - 0.055;
        }

        public static double[] fromLinear(double[] linearRGB) {
            return new double[]{SRGB.fromLinear(linearRGB[0]), SRGB.fromLinear(linearRGB[1]), SRGB.fromLinear(linearRGB[2])};
        }

        public static double[] fromARGB32(int argb) {
            return new double[]{(double)FastColor.ARGB32.m_13665_((int)argb) / 255.0, (double)FastColor.ARGB32.m_13667_((int)argb) / 255.0, (double)FastColor.ARGB32.m_13669_((int)argb) / 255.0};
        }

        public static int toARGB32(double[] rgb) {
            return FastColor.ARGB32.m_13660_((int)1, (int)((int)(rgb[0] * 255.0)), (int)((int)(rgb[1] * 255.0)), (int)((int)(rgb[2] * 255.0)));
        }
    }
}

