/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VoxelShapeUtil {
    private VoxelShapeUtil() {
    }

    public static VoxelShape createXZRotatedTowards(Direction dir, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (dir) {
            case Direction.DOWN -> VoxelShapeUtil.rotateXAxis(Rotation.ROT180, x1, y1, z1, x2, y2, z2);
            case Direction.NORTH -> VoxelShapeUtil.rotateXAxis(Rotation.ROT270, x1, y1, z1, x2, y2, z2);
            case Direction.SOUTH -> VoxelShapeUtil.rotateXAxis(Rotation.ROT90, x1, y1, z1, x2, y2, z2);
            case Direction.WEST -> VoxelShapeUtil.rotateZAxis(Rotation.ROT90, x1, y1, z1, x2, y2, z2);
            case Direction.EAST -> VoxelShapeUtil.rotateZAxis(Rotation.ROT270, x1, y1, z1, x2, y2, z2);
            default -> VoxelShapeUtil.box(x1, y1, z1, x2, y2, z2);
        };
    }

    public static VoxelShape createYRotatedTowards(Direction dir, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (dir) {
            case Direction.SOUTH -> VoxelShapeUtil.rotateYAxis(Rotation.ROT180, x1, y1, z1, x2, y2, z2);
            case Direction.WEST -> VoxelShapeUtil.rotateYAxis(Rotation.ROT270, x1, y1, z1, x2, y2, z2);
            case Direction.EAST -> VoxelShapeUtil.rotateYAxis(Rotation.ROT90, x1, y1, z1, x2, y2, z2);
            default -> VoxelShapeUtil.box(x1, y1, z1, x2, y2, z2);
        };
    }

    public static VoxelShape createRotated(Rotation rot, Direction.Axis axis, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> VoxelShapeUtil.rotateXAxis(rot, x1, y1, z1, x2, y2, z2);
            case Direction.Axis.Y -> VoxelShapeUtil.rotateYAxis(rot, x1, y1, z1, x2, y2, z2);
            case Direction.Axis.Z -> VoxelShapeUtil.rotateZAxis(rot, x1, y1, z1, x2, y2, z2);
        };
    }

    public static VoxelShape rotateXAxis(Rotation rot, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (rot) {
            case Rotation.ROT90 -> VoxelShapeUtil.box(x1, 16.0 - z1, y1, x2, 16.0 - z2, y2);
            case Rotation.ROT180 -> VoxelShapeUtil.box(x1, 16.0 - y1, z1, x2, 16.0 - y2, z2);
            case Rotation.ROT270 -> VoxelShapeUtil.box(x1, z1, 16.0 - y1, x2, z2, 16.0 - y2);
            default -> VoxelShapeUtil.box(x1, y1, z1, x2, y2, z2);
        };
    }

    public static VoxelShape rotateYAxis(Rotation rot, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (rot) {
            case Rotation.ROT90 -> VoxelShapeUtil.box(16.0 - z2, y1, x1, 16.0 - z1, y2, x2);
            case Rotation.ROT180 -> VoxelShapeUtil.box(16.0 - x2, y1, 16.0 - z2, 16.0 - x1, y2, 16.0 - z1);
            case Rotation.ROT270 -> VoxelShapeUtil.box(z1, y1, 16.0 - x2, z2, y2, 16.0 - x1);
            default -> VoxelShapeUtil.box(x1, y1, z1, x2, y2, z2);
        };
    }

    public static VoxelShape rotateZAxis(Rotation rot, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (rot) {
            case Rotation.ROT90 -> VoxelShapeUtil.box(16.0 - y1, x1, z1, 16.0 - y2, x2, z2);
            case Rotation.ROT180 -> VoxelShapeUtil.box(x1 * -1.0, 16.0 - y1, z1, x2 * -1.0, 16.0 - y2, z2);
            case Rotation.ROT270 -> VoxelShapeUtil.box(y1, 16.0 - x1, z1, y2, 16.0 - x2, z2);
            default -> VoxelShapeUtil.box(x1, y1, z1, x2, y2, z2);
        };
    }

    public static VoxelShape box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Shapes.m_83064_((AABB)VoxelShapeUtil.unitAABB(x1, y1, z1, x2, y2, z2));
    }

    public static AABB unitAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AABB(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }

    public static VoxelShape rotateYTo(Direction facing, AABB unitAABB) {
        return switch (facing) {
            case Direction.SOUTH -> Shapes.m_83048_((double)(1.0 - unitAABB.f_82291_), (double)unitAABB.f_82289_, (double)(1.0 - unitAABB.f_82293_), (double)(1.0 - unitAABB.f_82288_), (double)unitAABB.f_82292_, (double)(1.0 - unitAABB.f_82290_));
            case Direction.EAST -> Shapes.m_83048_((double)(1.0 - unitAABB.f_82293_), (double)unitAABB.f_82289_, (double)unitAABB.f_82288_, (double)(1.0 - unitAABB.f_82290_), (double)unitAABB.f_82292_, (double)unitAABB.f_82291_);
            case Direction.WEST -> Shapes.m_83048_((double)unitAABB.f_82290_, (double)unitAABB.f_82289_, (double)(1.0 - unitAABB.f_82291_), (double)unitAABB.f_82293_, (double)unitAABB.f_82292_, (double)(1.0 - unitAABB.f_82288_));
            default -> Shapes.m_83064_((AABB)unitAABB);
        };
    }

    public static enum Rotation {
        ROT0,
        ROT90,
        ROT180,
        ROT270;

    }
}

