/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class SoundUtil {
    private SoundUtil() {
    }

    private static float randomVanillaItemPitch(RandomSource rand) {
        return 1.0f / (rand.m_188501_() * 0.5f + 1.0f) + 0.2f;
    }

    private static float randomVanillaPitch(RandomSource rand) {
        return rand.m_188501_() * 0.1f + 0.9f;
    }

    public static void playItemSoundEffect(Level level, LivingEntity itemHolder, Supplier<SoundEvent> soundEventSupplier) {
        SoundUtil.playItemSoundEffect(level, itemHolder, soundEventSupplier.get());
    }

    public static void playItemSoundEffect(Level level, LivingEntity itemHolder, SoundEvent soundEvent) {
        if (level.f_46443_) {
            SoundUtil.clientPlayItemSound(level, itemHolder, soundEvent);
        } else {
            SoundUtil.broadcastItemSound((ServerLevel)level, itemHolder, soundEvent);
        }
    }

    public static void clientPlayItemSound(Level level, LivingEntity itemHolder, SoundEvent soundEvent) {
        Player player;
        SoundSource soundSource = itemHolder instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
        float pitch = SoundUtil.randomVanillaItemPitch(level.f_46441_);
        level.m_6263_(itemHolder instanceof Player ? (player = (Player)itemHolder) : null, itemHolder.m_20185_(), itemHolder.m_20227_(0.5), itemHolder.m_20189_(), soundEvent, soundSource, 0.8f, pitch);
    }

    public static void broadcastItemSound(ServerLevel level, LivingEntity itemHolder, SoundEvent soundEvent) {
        SoundSource soundSource = itemHolder instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
        float pitch = SoundUtil.randomVanillaItemPitch(level.f_46441_);
        level.m_6263_(null, itemHolder.m_20185_(), itemHolder.m_20227_(0.5), itemHolder.m_20189_(), soundEvent, soundSource, 0.8f, pitch);
    }

    public static void clientPlayBlockSound(Level level, BlockPos pos, Supplier<SoundEvent> soundEventSupplier) {
        SoundUtil.clientPlayBlockSound(level, pos, soundEventSupplier.get());
    }

    public static void clientPlayBlockSound(Level level, BlockPos pos, Supplier<SoundEvent> soundEventSupplier, float volume, float pitch) {
        SoundUtil.clientPlayBlockSound(level, pos, soundEventSupplier.get(), volume, pitch);
    }

    public static void clientPlayBlockSound(Level level, BlockPos pos, Supplier<SoundEvent> soundEventSupplier, float volume) {
        SoundUtil.clientPlayBlockSound(level, pos, soundEventSupplier.get(), volume, SoundUtil.randomVanillaPitch(level.f_46441_));
    }

    public static void clientPlayBlockSound(Level level, BlockPos pos, SoundEvent soundEvent) {
        SoundUtil.clientPlayBlockSound(level, pos, soundEvent, 1.0f, SoundUtil.randomVanillaPitch(level.f_46441_));
    }

    public static void clientPlayBlockSound(Level level, BlockPos pos, SoundEvent soundEvent, float volume, float pitch) {
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, volume, pitch, false);
    }

    public static void broadcastBlockSound(ServerLevel level, BlockPos pos, Supplier<SoundEvent> soundEventSupplier) {
        SoundUtil.broadcastBlockSound(level, pos, soundEventSupplier.get());
    }

    public static void broadcastBlockSound(ServerLevel level, BlockPos pos, SoundEvent soundEvent) {
        level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, SoundUtil.randomVanillaPitch(level.f_46441_));
    }

    public static void broadcastBlockSound(ServerLevel level, BlockPos pos, SoundEvent soundEvent, float volume, float pitch) {
        level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }
}

