/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.init.tags.ModEntityTags;
import com.github.elenterius.biomancy.mixin.accessor.AgeableMobAccessor;
import com.github.elenterius.biomancy.mixin.accessor.EntityAccessor;
import com.github.elenterius.biomancy.mixin.accessor.ServerLevelAccessor;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class MobUtil {
    private static final Marker LOG_MARKER = MarkerManager.getMarker((String)"MobUtil");

    private MobUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCreativePlayer(LivingEntity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.m_150110_().f_35937_) return false;
        return true;
    }

    public static boolean isBoss(LivingEntity entity) {
        return MobUtil.isBoss(entity.m_6095_());
    }

    public static boolean isBoss(EntityType<?> entityType) {
        return entityType.m_204039_(ModEntityTags.FORGE_BOSSES);
    }

    public static boolean isSkeleton(LivingEntity entity) {
        return entity instanceof AbstractSkeleton || entity instanceof SkeletonHorse || entity.m_6095_().m_204039_(EntityTypeTags.f_13120_);
    }

    public static boolean isWithered(LivingEntity entity) {
        return entity instanceof WitherBoss || entity instanceof WitherSkeleton;
    }

    public static boolean isUndead(LivingEntity entity) {
        return entity.m_6336_() == MobType.f_21641_;
    }

    public static boolean isNotUndead(LivingEntity entity) {
        return !MobUtil.isUndead(entity);
    }

    public static boolean isCloneable(EntityType<?> entityType) {
        return !entityType.m_204039_(ModEntityTags.NOT_CLONEABLE);
    }

    public static float getVolume(EntityType<?> entityType) {
        return entityType.m_20678_() * entityType.m_20678_() * entityType.m_20679_();
    }

    public static float getVolume(Entity entity) {
        return entity.m_20205_() * entity.m_20205_() * entity.m_20206_();
    }

    public static double getGravity(Entity entity) {
        double d;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            d = livingEntity.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        } else {
            d = 0.08;
        }
        return d;
    }

    public static double getWeight(Entity entity) {
        return (double)MobUtil.getVolume(entity) * MobUtil.getGravity(entity);
    }

    public static boolean anyMatch(EntityType<?> target, EntityType<?> a, EntityType<?> b) {
        return a == target || b == target;
    }

    public static void setAttributeBaseValue(LivingEntity livingEntity, Attribute attribute, double value) {
        AttributeInstance instance = livingEntity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22100_(value);
        } else {
            BiomancyMod.LOGGER.warn(LOG_MARKER, "Tried to set the value of a missing Attribute: {}, {}", (Object)attribute, (Object)livingEntity);
        }
    }

    public static void convertToBaby(Mob mob, boolean disableAgeing) {
        if (mob.m_6162_()) {
            return;
        }
        mob.m_6863_(true);
        if (mob instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)mob;
            ageableMob.m_146762_(-24000);
            if (disableAgeing) {
                ((AgeableMobAccessor)ageableMob).biomancy$setForcedAge(-24000);
            }
        }
    }

    public static void convertToAdult(Mob mob) {
        if (!mob.m_6162_()) {
            return;
        }
        mob.m_6863_(false);
        if (mob instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)mob;
            MobUtil.removeForcedAge(ageableMob);
        }
    }

    public static void removeForcedAge(AgeableMob mob) {
        AgeableMobAccessor accessor = (AgeableMobAccessor)mob;
        if (accessor.biomancy$getForcedAge() != 0) {
            accessor.biomancy$setForcedAge(0);
        }
    }

    public static <E extends Mob, T extends Mob> boolean convertMobTo(ServerLevel level, E mob, EntityType<T> outcomeMobType) {
        return MobUtil.convertMobTo(level, mob, outcomeMobType, true);
    }

    public static <E extends Mob, T extends Mob> boolean convertMobTo(ServerLevel level, E mob, EntityType<T> outcomeMobType, boolean copyEquipment) {
        return MobUtil.convertMobTo(level, mob, outcomeMobType, copyEquipment, (oldMob, outcome) -> {});
    }

    public static <E extends Mob, T extends Mob> boolean convertMobTo(ServerLevel world, E oldMob, EntityType<T> outcomeMobType, boolean copyEquipment, BiConsumer<E, T> onConvert) {
        Mob newMob;
        if (ForgeEventFactory.canLivingConvert(oldMob, outcomeMobType, timer -> {}) && (newMob = oldMob.m_21406_(outcomeMobType, copyEquipment)) != null) {
            newMob.m_6518_((net.minecraft.world.level.ServerLevelAccessor)world, world.m_6436_(oldMob.m_20183_()), MobSpawnType.CONVERSION, null, null);
            newMob.f_19802_ = 60;
            onConvert.accept(oldMob, newMob);
            ForgeEventFactory.onLivingConvert(oldMob, (LivingEntity)newMob);
            return true;
        }
        return false;
    }

    public static boolean convertLivingEntityTo(ServerLevel world, LivingEntity oldEntity, EntityType<?> outcomeType, Predicate<LivingEntity> validEntity) {
        if (oldEntity.m_213877_()) {
            return false;
        }
        Entity entity = outcomeType.m_20615_((Level)world);
        if (entity != null) {
            EntityType<?> entityType;
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && validEntity.test(livingEntity = (LivingEntity)entity) && ForgeEventFactory.canLivingConvert((LivingEntity)oldEntity, entityType = outcomeType, timer -> {})) {
                livingEntity.m_20359_((Entity)oldEntity);
                if (world.m_7967_((Entity)livingEntity)) {
                    oldEntity.m_146870_();
                    if (livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        mob.m_6518_((net.minecraft.world.level.ServerLevelAccessor)world, world.m_6436_(oldEntity.m_20183_()), MobSpawnType.CONVERSION, null, null);
                    }
                    livingEntity.f_19802_ = 60;
                    ForgeEventFactory.onLivingConvert((LivingEntity)oldEntity, (LivingEntity)livingEntity);
                    return true;
                }
            }
            entity.m_146870_();
        }
        return false;
    }

    public static Vec3 getAdjustedSpawnPositionFor(BlockPos pos, Vec3 clickLocation, Direction clickedFace, Entity entity) {
        BlockPos offsetPos = pos.m_121955_(clickedFace.m_122436_());
        int down = entity.m_9236_().m_8055_(offsetPos.m_7495_()).m_60795_() ? 0 : 1;
        int up = entity.m_9236_().m_8055_(offsetPos.m_7494_()).m_60795_() ? 0 : 1;
        int north = entity.m_9236_().m_8055_(offsetPos.m_122012_()).m_60795_() ? 0 : 1;
        int south = entity.m_9236_().m_8055_(offsetPos.m_122019_()).m_60795_() ? 0 : 1;
        int west = entity.m_9236_().m_8055_(offsetPos.m_122024_()).m_60795_() ? 0 : 1;
        int east = entity.m_9236_().m_8055_(offsetPos.m_122029_()).m_60795_() ? 0 : 1;
        float halfBBWidth = entity.m_20205_() * 0.5f;
        float halfBBHeight = entity.m_20206_() * 0.5f;
        double x = clickLocation.f_82479_;
        double y = clickLocation.f_82480_ - (double)halfBBHeight;
        double z = clickLocation.f_82481_;
        if (west + east == 2) {
            x = (double)offsetPos.m_123341_() + 0.5;
        } else if (east == 1) {
            x = (float)offsetPos.m_123341_() + 1.0f - halfBBWidth;
            if (clickLocation.f_82479_ < x) {
                x = clickLocation.f_82479_;
            }
        } else if (west == 1 && clickLocation.f_82479_ > (x = (double)((float)offsetPos.m_123341_() + halfBBWidth))) {
            x = clickLocation.f_82479_;
        }
        if (north + south == 2) {
            z = (double)offsetPos.m_123343_() + 0.5;
        } else if (south == 1) {
            z = (float)offsetPos.m_123343_() + 1.0f - halfBBWidth;
            if (clickLocation.f_82481_ < z) {
                z = clickLocation.f_82481_;
            }
        } else if (north == 1 && clickLocation.f_82481_ > (z = (double)((float)offsetPos.m_123343_() + halfBBWidth))) {
            z = clickLocation.f_82481_;
        }
        if (down + up == 2) {
            y = (double)offsetPos.m_123342_() + 0.5 - (double)halfBBHeight;
        } else if (down == 1) {
            y = offsetPos.m_123342_();
            if (clickLocation.f_82480_ - (double)halfBBHeight > y) {
                y = clickLocation.f_82480_ - (double)halfBBHeight;
            }
        } else if (up == 1 && clickLocation.f_82480_ - (double)halfBBHeight < (y = (double)((float)offsetPos.m_123342_() + 1.0f - entity.m_20206_()))) {
            y = clickLocation.f_82480_ - (double)halfBBHeight;
        }
        return new Vec3(x, y, z);
    }

    public static void randomizeUUID(Entity entity) {
        RandomSource randomSource = ((EntityAccessor)entity).biomancy$random();
        entity.m_20084_(Mth.m_216261_((RandomSource)randomSource));
    }

    public static boolean isEntityIdUnique(ServerLevel level, Entity entity) {
        return !MobUtil.isEntityIdLoaded(level, entity.m_20148_());
    }

    public static boolean isEntityIdLoaded(ServerLevel level, UUID uuid) {
        return ((ServerLevelAccessor)level).biomancy$entityManager().m_157550_(uuid);
    }
}

