/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.tooltip.EmptyLineTooltipComponent;
import com.github.elenterius.biomancy.tooltip.HrTooltipComponent;
import com.github.elenterius.biomancy.tooltip.TooltipContents;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    private static final Component SPACE = Component.m_237113_((String)" ");
    private static final Component TEXT_SEPARATOR = Component.m_237113_((String)", ");

    private ComponentUtil() {
    }

    public static Component nullToEmpty(@Nullable String text) {
        return Component.m_130674_((String)text);
    }

    public static MutableComponent literal(String text) {
        return Component.m_237113_((String)text);
    }

    public static MutableComponent translatable(String translationKey) {
        return Component.m_237115_((String)translationKey);
    }

    public static MutableComponent translatable(String translationKey, Object ... args) {
        return Component.m_237110_((String)translationKey, (Object[])args);
    }

    public static MutableComponent mutable() {
        return Component.m_237119_();
    }

    public static Component empty() {
        return CommonComponents.f_237098_;
    }

    public static Component space() {
        return SPACE;
    }

    public static Component emptyLine() {
        return TooltipHacks.EMPTY_LINE_COMPONENT;
    }

    public static Component newLine() {
        return CommonComponents.f_178388_;
    }

    public static Component ellipsis() {
        return CommonComponents.f_238772_;
    }

    public static Component textSeparator() {
        return TEXT_SEPARATOR;
    }

    public static Component horizontalLine() {
        return TooltipHacks.HR_COMPONENT;
    }

    public static MutableComponent keybind(KeyMapping keyMapping) {
        return Component.m_237117_((String)keyMapping.m_90860_());
    }

    public static MutableComponent keybind(String keyName) {
        return Component.m_237117_((String)keyName);
    }

    public static MutableComponent nbt(String nbtPathPattern, boolean interpreting, Optional<Component> separator, DataSource dataSource) {
        return Component.m_237105_((String)nbtPathPattern, (boolean)interpreting, separator, (DataSource)dataSource);
    }

    public static MutableComponent score(String name, String objective) {
        return Component.m_237099_((String)name, (String)objective);
    }

    public static MutableComponent selector(String pattern, Optional<Component> separator) {
        return MutableComponent.m_237204_((ComponentContents)new SelectorContents(pattern, separator));
    }

    public static MutableComponent tooltip(TooltipComponent component) {
        return TooltipHacks.wrap(component);
    }

    public static List<Component> splitLines(Locale locale, String text, int maxLength, Style style) {
        BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
        breakIterator.setText(text);
        ArrayList<Component> lines = new ArrayList<Component>();
        StringBuilder currentLine = new StringBuilder();
        int start = breakIterator.first();
        int end = breakIterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            if (currentLine.length() + word.length() >= maxLength) {
                lines.add((Component)ComponentUtil.literal(currentLine.toString()).m_130948_(style));
                currentLine = new StringBuilder();
            }
            if (word.equals("\n")) {
                lines.add(ComponentUtil.emptyLine());
            } else if (word.contains("\n")) {
                word = word.replace("\n", "");
                currentLine.append(word);
                lines.add((Component)ComponentUtil.literal(currentLine.toString()).m_130948_(style));
                currentLine = new StringBuilder();
            } else {
                currentLine.append(word);
            }
            start = end;
            end = breakIterator.next();
        }
        if (!currentLine.isEmpty()) {
            lines.add((Component)ComponentUtil.literal(currentLine.toString()).m_130948_(style));
        }
        return lines;
    }

    public static List<Component> splitLines(Locale locale, String text, Style style) {
        BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
        breakIterator.setText(text);
        ArrayList<Component> lines = new ArrayList<Component>();
        StringBuilder currentLine = new StringBuilder();
        int start = breakIterator.first();
        int end = breakIterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            if (word.equals("\n")) {
                lines.add(ComponentUtil.emptyLine());
            } else if (word.contains("\n")) {
                word = word.replace("\n", "");
                currentLine.append(word);
                lines.add((Component)ComponentUtil.literal(currentLine.toString()).m_130948_(style));
                currentLine = new StringBuilder();
            } else {
                currentLine.append(word);
            }
            start = end;
            end = breakIterator.next();
        }
        if (!currentLine.isEmpty()) {
            lines.add((Component)ComponentUtil.literal(currentLine.toString()).m_130948_(style));
        }
        return lines;
    }

    public static <T extends Component> T setStyles(T component, Style style) {
        if (component instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            mutable.m_130948_(style);
        }
        component.m_7360_().forEach(sibling -> ComponentUtil.setStyles(sibling, style));
        return component;
    }

    private static final class TooltipHacks {
        static final MutableComponent HR_COMPONENT = TooltipHacks.wrap(new HrTooltipComponent());
        static final MutableComponent EMPTY_LINE_COMPONENT = TooltipHacks.wrap(new EmptyLineTooltipComponent());

        private TooltipHacks() {
        }

        private static MutableComponent wrap(TooltipComponent component) {
            return MutableComponent.m_237204_((ComponentContents)new TooltipContents(component));
        }
    }
}

