/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlob;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.integration.pehkui.PehkuiHelper;
import com.github.elenterius.biomancy.mixin.accessor.ArmorStandAccessor;
import com.github.elenterius.biomancy.mixin.accessor.SlimeAccessor;
import com.github.elenterius.biomancy.serum.BasicSerum;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;

public class ShrinkingSerum
extends BasicSerum {
    public ShrinkingSerum(int color) {
        super(color);
    }

    private void resizeArmorStand(ArmorStandAccessor armorStand) {
        armorStand.biomancy$setSmall(true);
    }

    private void resizeFleshBlob(FleshBlob fleshBlob) {
        byte blobSize = fleshBlob.getBlobSize();
        if (blobSize > 1) {
            fleshBlob.setBlobSize((byte)(blobSize - 1), false);
        }
    }

    private void resizeSlime(Slime slime) {
        int slimeSize = slime.m_33632_();
        if (slimeSize > 1) {
            ((SlimeAccessor)slime).biomancy$setSlimeSize(slimeSize - 1, false);
        }
    }

    private void resizeWithPehkui(LivingEntity target) {
        PehkuiHelper pehkuiHelper = ModsCompatHandler.getPehkuiHelper();
        float currentScale = pehkuiHelper.getScale(target);
        if (currentScale > 0.25f) {
            pehkuiHelper.setScale(target, Mth.m_14036_((float)(currentScale - 0.25f), (float)0.25f, (float)2.0f));
        }
    }

    @Override
    public boolean canAffectEntity(CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        return target instanceof Mob || target instanceof Player;
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        ArmorStand armorStand;
        if (target instanceof Slime) {
            Slime slime = (Slime)target;
            this.resizeSlime(slime);
        } else if (target instanceof FleshBlob) {
            FleshBlob fleshBlob = (FleshBlob)target;
            this.resizeFleshBlob(fleshBlob);
        } else if (target instanceof ArmorStand && !(armorStand = (ArmorStand)target).m_31666_()) {
            this.resizeArmorStand((ArmorStandAccessor)armorStand);
        } else {
            this.resizeWithPehkui(target);
        }
    }

    @Override
    public boolean canAffectPlayerSelf(CompoundTag tag, Player targetSelf) {
        return true;
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
        this.resizeWithPehkui((LivingEntity)targetSelf);
    }
}

