/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.serum.BasicSerum;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class InsomniaCureSerum
extends BasicSerum {
    protected static final int PHANTOM_SPAWN_THRESHOLD = 72000;

    public InsomniaCureSerum(int color) {
        super(color);
    }

    @Override
    public boolean canAffectEntity(CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        return target instanceof Player;
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            this.affectPlayerSelf(tag, player);
        }
    }

    @Override
    public boolean canAffectPlayerSelf(CompoundTag tag, Player targetSelf) {
        int ticksSinceRest = this.getTimeSinceRest(targetSelf);
        if ((float)ticksSinceRest <= 59976.0f) {
            if (!targetSelf.m_9236_().f_46443_) {
                targetSelf.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_sleepy"), true);
            }
            return false;
        }
        return true;
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
        targetSelf.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
        InsomniaCureSerum.applyDrowsyEffect((LivingEntity)targetSelf);
    }

    private static void applyDrowsyEffect(LivingEntity livingEntity) {
        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.DROWSY.get(), 4800, 0, false, false, true));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, 0, false, false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 400, 0, false, false, false));
    }

    private int getTimeSinceRest(Player player) {
        StatsCounter statsCounter = player.m_9236_().f_46443_ ? ((LocalPlayer)player).m_108630_() : ((ServerPlayer)player).m_8951_();
        return Mth.m_14045_((int)statsCounter.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)), (int)1, (int)Integer.MAX_VALUE);
    }
}

