/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlob;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.integration.pehkui.PehkuiHelper;
import com.github.elenterius.biomancy.mixin.accessor.ArmorStandAccessor;
import com.github.elenterius.biomancy.mixin.accessor.SlimeAccessor;
import com.github.elenterius.biomancy.serum.BasicSerum;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EnlargementSerum
extends BasicSerum {
    public EnlargementSerum(int color) {
        super(color);
    }

    private void resizeArmorStand(ArmorStand armorStand) {
        ((ArmorStandAccessor)armorStand).biomancy$setSmall(false);
    }

    private void resizeFleshBlob(@Nullable LivingEntity source, FleshBlob fleshBlob) {
        byte blobSize = fleshBlob.getBlobSize();
        if (blobSize < 10) {
            fleshBlob.setBlobSize((byte)(blobSize + 1), false);
        } else {
            DamageSource explosionDamage = fleshBlob.m_9236_().m_269111_().m_269036_((Entity)source, (Entity)fleshBlob);
            fleshBlob.m_6469_(explosionDamage, fleshBlob.m_21223_());
        }
    }

    private void resizeSlime(@Nullable LivingEntity source, Slime slime) {
        int slimeSize = slime.m_33632_();
        if (slimeSize < 25) {
            ((SlimeAccessor)slime).biomancy$setSlimeSize(slimeSize + 1, false);
        } else {
            DamageSource explosionDamage = slime.m_9236_().m_269111_().m_269036_((Entity)source, (Entity)slime);
            slime.m_6469_(explosionDamage, slime.m_21223_());
        }
    }

    private void resizeWithPehkui(LivingEntity target) {
        PehkuiHelper pehkuiHelper = ModsCompatHandler.getPehkuiHelper();
        float currentScale = pehkuiHelper.getScale(target);
        if (currentScale < 2.0f) {
            pehkuiHelper.setScale(target, Mth.m_14036_((float)(currentScale + 0.25f), (float)0.25f, (float)2.0f));
        }
    }

    @Override
    public boolean canAffectEntity(CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        return target instanceof Mob || target instanceof Player;
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        ArmorStand armorStand;
        if (target instanceof Slime) {
            Slime slime = (Slime)target;
            this.resizeSlime(source, slime);
        } else if (target instanceof FleshBlob) {
            FleshBlob fleshBlob = (FleshBlob)target;
            this.resizeFleshBlob(source, fleshBlob);
        } else if (target instanceof ArmorStand && (armorStand = (ArmorStand)target).m_31666_()) {
            this.resizeArmorStand(armorStand);
        } else {
            this.resizeWithPehkui(target);
        }
    }

    @Override
    public boolean canAffectPlayerSelf(CompoundTag tag, Player targetSelf) {
        return true;
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
        this.resizeWithPehkui((LivingEntity)targetSelf);
    }
}

