/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.mixin.client;

import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.integration.BioForgeCompat;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientRecipeBook.class}, priority=999)
public abstract class ClientRecipeBookMixin {
    @Shadow
    private List<RecipeCollection> f_90620_;
    @Shadow
    private Map<RecipeBookCategories, List<RecipeCollection>> f_90619_;

    @Shadow
    private static RecipeBookCategories m_90646_(Recipe<?> pRecipe) {
        return null;
    }

    @Inject(method={"setupCollections"}, at={@At(value="HEAD")})
    private void onSetupCollections(Iterable<Recipe<?>> recipes, RegistryAccess registryAccess, CallbackInfo ci) {
        if (BioForgeCompat.isRecipeCollectionOverwriteEnabled()) {
            this.biomancy$overwriteRecipeCollections(recipes, registryAccess);
        }
    }

    @Unique
    private void biomancy$overwriteRecipeCollections(Iterable<Recipe<?>> allRecipes, RegistryAccess registryAccess) {
        Map<RecipeBookCategories, List<List<Recipe<?>>>> categorizedRecipes = ClientRecipeBookMixin.biomancy$categorizeBioForgeRecipes(allRecipes);
        HashMap recipeCategories = new HashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        categorizedRecipes.forEach((category, groupedRecipes) -> recipeCategories.put(category, groupedRecipes.stream().map(recipes -> {
            RecipeCollection collection = new RecipeCollection(registryAccess, recipes);
            builder.add((Object)collection);
            return collection;
        }).toList()));
        RecipeBookCategories.f_92260_.forEach((mainCategory, subCategories) -> recipeCategories.put(mainCategory, subCategories.stream().flatMap(category -> recipeCategories.getOrDefault(category, List.of()).stream()).toList()));
        this.f_90619_ = Map.copyOf(recipeCategories);
        this.f_90620_ = builder.build();
    }

    @Unique
    private static Map<RecipeBookCategories, List<List<Recipe<?>>>> biomancy$categorizeBioForgeRecipes(Iterable<Recipe<?>> recipes) {
        HashMap map = Maps.newHashMap();
        HashBasedTable table = HashBasedTable.create();
        for (Recipe<?> recipe : recipes) {
            String group;
            if (recipe.m_6671_() != ModRecipes.BIO_FORGING_RECIPE_TYPE.get() || recipe.m_5598_() || recipe.m_142505_()) continue;
            RecipeBookCategories category = ClientRecipeBookMixin.m_90646_(recipe);
            String string = group = recipe.m_6076_().isEmpty() ? recipe.m_6423_().toString() : recipe.m_6076_();
            if (group.isEmpty()) {
                map.computeIfAbsent(category, categories -> Lists.newArrayList()).add(List.of(recipe));
                continue;
            }
            List list = (List)table.get((Object)category, (Object)group);
            if (list == null) {
                list = Lists.newArrayList();
                table.put((Object)category, (Object)group, (Object)list);
                map.computeIfAbsent(category, categories -> Lists.newArrayList()).add(list);
            }
            list.add(recipe);
        }
        return map;
    }
}

