/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.loot;

import com.github.elenterius.biomancy.enchantment.DespoilEnchantment;
import com.github.elenterius.biomancy.init.ModEnchantments;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DespoilLootModifier
extends LootModifier {
    public static final Supplier<Codec<DespoilLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DespoilLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DespoilLootModifier::new)));
    public static final String LOOT_PREFIX = "biomancy/despoil/";

    public DespoilLootModifier() {
        this(new LootItemCondition[]{LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33717_(Boolean.valueOf(false)).m_33716_())).m_6409_(), LootItemKilledByPlayerCondition.m_81901_().m_6409_()});
    }

    public DespoilLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public static ResourceLocation getLootTableId(EntityType<?> entityType) {
        ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_(entityType);
        return key.m_246208_(LOOT_PREFIX);
    }

    public static ResourceLocation getLootTableId(ResourceLocation entityTypeId) {
        return entityTypeId.m_246208_(LOOT_PREFIX);
    }

    protected static int getDespoilLevel(LootContext lootContext) {
        Entity killer = (Entity)lootContext.m_78953_(LootContextParams.f_81458_);
        if (killer instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)killer;
            int itemDespoilLevel = ((DespoilEnchantment)((Object)ModEnchantments.DESPOIL.get())).m_44684_(livingEntity).values().stream().mapToInt(DespoilLootModifier::getDespoilLevel).max().orElse(lootContext.m_230907_().m_188501_() < 0.05f ? 1 : 0);
            MobEffectInstance effectInstance = livingEntity.m_21124_((MobEffect)ModMobEffects.DESPOIL.get());
            int effectDespoilLevel = effectInstance != null ? effectInstance.m_19564_() + 1 : 0;
            return Math.max(itemDespoilLevel, effectDespoilLevel);
        }
        return 0;
    }

    protected static int getDespoilLevel(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)ModEnchantments.DESPOIL.get());
    }

    protected static boolean hurtAndBreak(LootContext lootContext, Item item, int amount) {
        Entity killer = (Entity)lootContext.m_78953_(LootContextParams.f_81458_);
        if (killer instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)killer;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack stack;
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.HAND || !(stack = livingEntity.m_6844_(equipmentSlot)).m_150930_(item)) continue;
                stack.m_41622_(amount, livingEntity, user -> user.m_21166_(equipmentSlot));
                return true;
            }
        }
        return false;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int despoilLevel;
        Entity thisEntity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if ((thisEntity instanceof LivingEntity || thisEntity instanceof Player) && (despoilLevel = DespoilLootModifier.getDespoilLevel(context)) > 0) {
            LootTable lootTable = this.getLootTable(context.m_78952_(), thisEntity);
            if (lootTable == LootTable.f_79105_) {
                return generatedLoot;
            }
            float despoilChance = 1.0f;
            if (!DespoilLootModifier.hurtAndBreak(context, (Item)ModItems.DESPOIL_SICKLE.get(), 1)) {
                despoilChance -= 0.15f;
            }
            LootParams lootParams = this.createLootParams(context);
            Consumer stackSplitter = LootTable.m_246283_((ServerLevel)context.m_78952_(), arg_0 -> generatedLoot.add(arg_0));
            for (int rolls = despoilLevel; rolls > 0; --rolls) {
                if (context.m_230907_().m_188501_() > despoilChance) continue;
                DespoilLootModifier.getRandomItems(lootTable, lootParams, stackSplitter);
            }
        }
        return generatedLoot;
    }

    private static void getRandomItems(LootTable lootTable, LootParams lootParams, Consumer<ItemStack> output) {
        lootTable.m_287190_(lootParams, output);
    }

    protected LootTable getLootTable(ServerLevel level, Entity entity) {
        ResourceLocation lootTableId = DespoilLootModifier.getLootTableId(entity.m_6095_());
        return level.m_7654_().m_278653_().m_278676_(lootTableId);
    }

    protected LootParams createLootParams(LootContext context) {
        LootParams.Builder builder = new LootParams.Builder(context.m_78952_()).m_287286_(LootContextParams.f_81455_, (Object)((Entity)context.m_165124_(LootContextParams.f_81455_))).m_287286_(LootContextParams.f_81460_, (Object)((Vec3)context.m_165124_(LootContextParams.f_81460_))).m_287286_(LootContextParams.f_81457_, (Object)((DamageSource)context.m_165124_(LootContextParams.f_81457_))).m_287289_(LootContextParams.f_81458_, (Object)((Entity)context.m_165124_(LootContextParams.f_81458_))).m_287289_(LootContextParams.f_81459_, (Object)((Entity)context.m_165124_(LootContextParams.f_81459_)));
        if (context.m_78936_(LootContextParams.f_81456_)) {
            Player player = (Player)context.m_165124_(LootContextParams.f_81456_);
            builder = builder.m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_());
        }
        return builder.m_287235_(LootContextParamSets.f_81415_);
    }

    protected LootTable createDynamicLootTableFallback(LivingEntity livingEntity) {
        EntityType entityType = livingEntity.m_6095_();
        LootTable.Builder lootTable = LootTable.m_79147_();
        LootPool.Builder lootPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        boolean hasLoot = false;
        if (entityType.m_204039_(EntityTypeTags.f_13120_)) {
            lootPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MOB_MARROW.get())).m_79707_(70).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
            hasLoot = true;
        }
        if (this.isValidForMeatyLoot(livingEntity, entityType)) {
            lootPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MOB_SINEW.get())).m_79707_(50).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GENERIC_MOB_GLAND.get())).m_79707_(30).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
            hasLoot = true;
        }
        return hasLoot ? lootTable.m_79161_(lootPool).m_79167_() : LootTable.f_79105_;
    }

    private boolean isValidForMeatyLoot(LivingEntity livingEntity, EntityType<?> entityType) {
        if (livingEntity instanceof Zombie) {
            return true;
        }
        if (livingEntity instanceof ZombieHorse) {
            return true;
        }
        if (livingEntity instanceof ZombifiedPiglin) {
            return true;
        }
        if (livingEntity instanceof ZombieVillager) {
            return true;
        }
        if (livingEntity instanceof Villager) {
            return true;
        }
        if (livingEntity instanceof AbstractGolem) {
            return false;
        }
        if (livingEntity instanceof Slime) {
            return false;
        }
        if (livingEntity instanceof Allay) {
            return false;
        }
        if (livingEntity instanceof Vex) {
            return false;
        }
        if (livingEntity instanceof Phantom) {
            return false;
        }
        if (livingEntity instanceof Warden) {
            return false;
        }
        return livingEntity.m_6336_() != MobType.f_21641_;
    }
}

