/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon;

import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.entity.mob.ControllableMob;
import com.github.elenterius.biomancy.entity.mob.FleshkinHumanoid;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.item.KeyPressListener;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.ownable.OwnableMob;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ControlStaffItem
extends Item
implements KeyPressListener,
ItemTooltipStyleProvider {
    public ControlStaffItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        ControllableMob.Command command = this.getCommand(stack).cycle();
        player.m_5496_(SoundEvents.f_11915_, 0.8f, 0.25f + level.f_46441_.m_188501_() * 0.25f);
        return InteractionResultHolder.m_19090_((Object)command.serialize());
    }

    @Override
    public void onServerReceiveKeyPress(ItemStack stack, ServerLevel level, Player player, byte flags) {
        ControllableMob.Command command = ControllableMob.Command.deserialize(flags);
        this.setCommand(stack, command);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (context.m_43725_().f_46443_ || player == null) {
            return InteractionResult.FAIL;
        }
        List mobs = context.m_43725_().m_6443_(Mob.class, player.m_20191_().m_82400_(16.0), mob -> {
            OwnableMob ownable;
            return mob instanceof ControllableMob && mob instanceof OwnableMob && (ownable = (OwnableMob)mob).isOwner((Entity)player);
        });
        int size = mobs.size();
        if (size == 0) {
            MutableComponent component = ComponentUtil.literal("Couldn't find any controllable mobs nearby!").m_130940_(ChatFormatting.RED);
            player.m_5661_((Component)component, true);
            return InteractionResult.FAIL;
        }
        ControllableMob.Command command = this.getCommand(stack);
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        for (Mob mob2 : mobs) {
            ControllableMob<Mob> controllable = ControllableMob.cast(mob2);
            controllable.updateRestriction(command, pos);
            controllable.setActiveCommand(command);
        }
        FleshkinHumanoid.displayCommandSetMsg(player, (Component)ComponentUtil.literal(size + (size > 1 ? " mobs" : " mob")), command);
        return InteractionResult.SUCCESS;
    }

    public ControllableMob.Command getCommand(ItemStack stack) {
        return ControllableMob.Command.deserialize(stack.m_41784_().m_128445_("Command"));
    }

    public void setCommand(ItemStack stack, ControllableMob.Command command) {
        stack.m_41784_().m_128344_("Command", command.serialize());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)TextComponentUtil.getTooltipText("command").m_130946_(": ").m_130944_(new ChatFormatting[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ComponentUtil.literal(this.getCommand(stack).toString()).m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action_cycle")).m_130940_(ChatFormatting.DARK_GRAY));
    }
}

