/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.injector;

import com.github.elenterius.biomancy.api.serum.Serum;
import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.api.serum.SerumInjector;
import com.github.elenterius.biomancy.client.gui.InjectorScreen;
import com.github.elenterius.biomancy.client.render.item.injector.InjectorRenderer;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.init.ModEnchantments;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.inventory.InjectorItemInventory;
import com.github.elenterius.biomancy.inventory.LargeSingleItemStackHandler;
import com.github.elenterius.biomancy.inventory.SingleItemStackHandler;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.item.KeyPressListener;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.item.injector.InjectionScheduler;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.CombatUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class InjectorItem
extends Item
implements SerumInjector,
ItemTooltipStyleProvider,
KeyPressListener,
GeoItem {
    public static final short MAX_SLOT_SIZE = 16;
    public static final String INVENTORY_TAG = "inventory";
    public static final int COOL_DOWN_TICKS = 25;
    public static final int SCHEDULE_TICKS = Mth.m_14167_((float)6.3999996f);
    protected static final String CURRENT_VICTIM_KEY = "CurrentVictimId";
    protected static final String CURRENT_HOST_KEY = "CurrentHostId";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final String NEEDLE_CONTROLLER = "needle";
    protected static final String MAIN_CONTROLLER = "main";

    public InjectorItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static boolean tryInjectLivingEntity(ServerLevel level, BlockPos pos, ItemStack stack) {
        InjectorItem injectorItem;
        block7: {
            block6: {
                Item item = stack.m_41720_();
                if (!(item instanceof InjectorItem)) break block6;
                injectorItem = (InjectorItem)item;
                if (stack.m_41773_() < stack.m_41776_() - 1) break block7;
            }
            return false;
        }
        Serum serum = injectorItem.getSerum(stack);
        if (!serum.isEmpty()) {
            List entities = level.m_6443_(LivingEntity.class, new AABB(pos), EntitySelector.f_20408_);
            if (entities.isEmpty()) {
                return false;
            }
            LivingEntity target = (LivingEntity)entities.get(0);
            if (target.m_6084_() && InjectorItem.dispenserAffectEntity(level, pos, serum, stack, injectorItem, target)) {
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.INJECTOR_INJECT.get(), SoundSource.BLOCKS, 0.8f, 1.0f / (level.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
                level.m_46796_(2008, target.m_20183_(), 0);
                return true;
            }
        }
        return false;
    }

    private static boolean dispenserAffectEntity(ServerLevel level, BlockPos pos, Serum serum, ItemStack injectorStack, InjectorItem injectorItem, LivingEntity target) {
        if (CombatUtil.canPierceThroughArmor(injectorStack, target, null)) {
            CompoundTag dataTag = Serum.getDataTag(injectorStack);
            if (serum.canAffectEntity(dataTag, null, target)) {
                float damage;
                serum.affectEntity(level, dataTag, null, target);
                injectorItem.consumeSerum(injectorStack, null);
                injectorStack.m_220157_(1, level.m_213780_(), null);
                float damagePct = 1.0f;
                for (ItemStack itemStack : target.m_6168_()) {
                    AcolyteArmorItem armor;
                    Item item = itemStack.m_41720_();
                    if (!(item instanceof AcolyteArmorItem) || !(armor = (AcolyteArmorItem)item).hasNutrients(itemStack)) continue;
                    damagePct -= 0.25f;
                }
                if (injectorStack.getEnchantmentLevel((Enchantment)ModEnchantments.ANESTHETIC.get()) <= 0 && (damage = 0.5f * damagePct) > 0.0f) {
                    target.m_6469_(level.m_269111_().m_269396_(null), damage);
                }
                return true;
            }
        } else {
            injectorStack.m_220157_(2, level.m_213780_(), null);
            level.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.5f, 1.0f / (level.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
        return false;
    }

    public static Optional<LargeSingleItemStackHandler> getItemHandler(ItemStack stack) {
        return stack.getCapability(ModCapabilities.ITEM_HANDLER).map(LargeSingleItemStackHandler.class::cast);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tryToOpenClientScreen(InteractionHand hand) {
        Screen currScreen = Minecraft.m_91087_().f_91080_;
        if (currScreen == null && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().m_91152_((Screen)new InjectorScreen(hand));
            Minecraft.m_91087_().f_91074_.m_6330_((SoundEvent)ModSoundEvents.UI_RADIAL_MENU_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
            InteractionHand hand = slot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            this.tryToOpenClientScreen(hand);
        }
        return InteractionResultHolder.m_19100_((Object)flags);
    }

    @Override
    public void onServerReceiveKeyPress(ItemStack stack, ServerLevel level, Player player, byte flags) {
        if (flags == -2) {
            this.clearInventory(stack, player);
        }
        if (flags >= 0) {
            this.setInventory(stack, player, flags);
        }
    }

    private void setInventory(ItemStack injector, Player player, int slotIndex) {
        Inventory playerInventory = player.m_150109_();
        ItemStack foundStack = playerInventory.m_8020_(slotIndex);
        Item item = foundStack.m_41720_();
        if (!(item instanceof SerumContainer)) {
            return;
        }
        InjectorItem.getItemHandler(injector).ifPresent(handler -> {
            ItemStack oldStack = ItemStack.f_41583_;
            if (!handler.getStack().m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)foundStack, (ItemStack)handler.getStack())) {
                oldStack = handler.extractItem(handler.getMaxAmount(), false);
            }
            ItemStack remainder = handler.insertItem(foundStack, false);
            playerInventory.m_6836_(slotIndex, remainder);
            if (remainder.m_41619_() && !handler.isFull()) {
                int slots = playerInventory.m_6643_();
                for (int idx = 0; idx < slots; ++idx) {
                    ItemStack stack = playerInventory.m_8020_(idx);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)handler.getStack())) continue;
                    remainder = handler.insertItem(stack, false);
                    playerInventory.m_6836_(idx, remainder);
                    if (!remainder.m_41619_()) break;
                }
            }
            if (!oldStack.m_41619_()) {
                playerInventory.m_150079_(oldStack);
            }
        });
    }

    private void clearInventory(ItemStack injector, Player player) {
        InjectorItem.getItemHandler(injector).ifPresent(handler -> {
            if (!handler.getStack().m_41619_()) {
                ItemStack result = handler.extractItem(handler.getMaxAmount(), false);
                player.m_150109_().m_150079_(result);
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_36335_().m_41519_((Item)this) || !this.canInteractWithPlayerSelf(stack, player)) {
            SoundUtil.playItemSoundEffect(level, (LivingEntity)player, ModSoundEvents.INJECTOR_FAIL);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.f_46443_) {
            InjectionScheduler.schedule(this, stack, player, (LivingEntity)player, SCHEDULE_TICKS);
            this.broadcastAnimation((ServerLevel)level, player, stack, InjectorAnimation.INJECT_SELF);
            player.m_36335_().m_41524_((Item)this, 25);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack copyOfStack, Player player, LivingEntity target, InteractionHand usedHand) {
        Level level = player.m_9236_();
        if (!this.canInteractWithLivingTarget(copyOfStack, player, target)) {
            if (level.f_46443_) {
                SoundUtil.clientPlayItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.INJECTOR_FAIL.get());
            }
            return InteractionResult.FAIL;
        }
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResult.FAIL;
        }
        player.m_36335_().m_41524_((Item)this, 25);
        ItemStack realStack = player.m_150110_().f_35937_ ? player.m_21120_(usedHand) : copyOfStack;
        InjectionScheduler.schedule(this, realStack, player, target, SCHEDULE_TICKS);
        this.broadcastAnimation((ServerLevel)target.m_9236_(), player, realStack, InjectorAnimation.INJECT_OTHER);
        return InteractionResult.CONSUME;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                InjectionScheduler.tick(serverLevel, this, stack, player);
            }
        }
    }

    @Override
    public Serum getSerum(ItemStack stack) {
        return InjectorItem.getItemHandler(stack).map(SingleItemStackHandler::getItem).filter(SerumContainer.class::isInstance).map(SerumContainer.class::cast).map(SerumContainer::getSerum).orElse(Serum.EMPTY);
    }

    public ItemStack getSerumItemStack(ItemStack stack) {
        return InjectorItem.getItemHandler(stack).map(SingleItemStackHandler::getStack).orElse(ItemStack.f_41583_);
    }

    public void consumeSerum(ItemStack stack, @Nullable Player player) {
        if (player != null && player.m_7500_()) {
            return;
        }
        InjectorItem.getItemHandler(stack).ifPresent(handler -> this.consumeSerum((LargeSingleItemStackHandler)handler, player));
    }

    private void consumeSerum(LargeSingleItemStackHandler handler, @Nullable Player player) {
        ItemStack containerItem;
        ItemStack stack;
        if (handler.getStack().m_41720_() instanceof SerumContainer && (stack = handler.extractItem(1, false)).hasCraftingRemainingItem() && !(containerItem = stack.getCraftingRemainingItem()).m_41619_() && player != null && !player.m_36356_(containerItem)) {
            player.m_36176_(containerItem, false);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44961_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return 15;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InventoryCapability(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final InjectorRenderer renderer = new InjectorRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    @Nullable
    private InjectorRenderer getInjectorRenderer(InjectorItem item) {
        InjectorRenderer injectorRenderer;
        BlockEntityWithoutLevelRenderer renderer = IClientItemExtensions.of((Item)this).getCustomRenderer();
        return renderer instanceof InjectorRenderer ? (injectorRenderer = (InjectorRenderer)renderer) : null;
    }

    public void setEntityHost(ItemStack stack, Entity entity) {
        if (stack.m_41619_()) {
            return;
        }
        stack.m_41784_().m_128405_(CURRENT_HOST_KEY, entity.m_19879_());
    }

    public void setInjectionSuccess(ItemStack stack, boolean flag) {
        if (stack.m_41619_()) {
            return;
        }
        stack.m_41784_().m_128379_("IsInjectionSuccess", flag);
    }

    public boolean getInjectionSuccess(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41784_().m_128471_("IsInjectionSuccess");
    }

    public void removeEntityHost(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            tag.m_128473_(CURRENT_HOST_KEY);
        }
    }

    @Nullable
    public Entity getEntityHost(ItemStack stack, Level level) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128425_(CURRENT_HOST_KEY, 99)) {
            return level.m_6815_(tag.m_128451_(CURRENT_HOST_KEY));
        }
        return null;
    }

    public void setEntityVictim(ItemStack stack, Entity entity) {
        if (stack.m_41619_()) {
            return;
        }
        stack.m_41784_().m_128405_(CURRENT_VICTIM_KEY, entity.m_19879_());
    }

    public void removeEntityVictim(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            tag.m_128473_(CURRENT_VICTIM_KEY);
        }
    }

    @Nullable
    public Entity getEntityVictim(ItemStack stack, Level level) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128425_(CURRENT_VICTIM_KEY, 99)) {
            return level.m_6815_(tag.m_128451_(CURRENT_VICTIM_KEY));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onSoundKeyFrame(ItemStack stack, String soundId, double animationTick) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (!this.getInjectionSuccess(stack)) {
            return;
        }
        Entity soundOrigin = this.getEntityHost(stack, (Level)level);
        if (soundOrigin == null) {
            return;
        }
        LocalPlayer client = Minecraft.m_91087_().f_91074_;
        level.m_6263_((Player)client, soundOrigin.m_20185_(), soundOrigin.m_20227_(0.5), soundOrigin.m_20189_(), (SoundEvent)ModSoundEvents.INJECTOR_INJECT.get(), SoundSource.PLAYERS, 0.8f, 1.0f / (level.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        Entity victim = this.getEntityVictim(stack, (Level)level);
        if (victim != null) {
            level.m_46796_(2008, victim.m_20183_(), 0);
        }
    }

    private void soundListener(SoundKeyframeEvent<InjectorItem> event) {
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)this).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof InjectorRenderer) {
            InjectorRenderer renderer = (InjectorRenderer)blockEntityWithoutLevelRenderer;
            this.onSoundKeyFrame(renderer.getCurrentItemStack(), event.getKeyframeData().getSound(), event.getAnimationTick());
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController mainController = new AnimationController((GeoAnimatable)this, MAIN_CONTROLLER, 1, event -> PlayState.CONTINUE);
        InjectorAnimation.registerTriggerableAnimations((AnimationController<InjectorItem>)mainController);
        mainController.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{mainController});
        AnimationController needleController = new AnimationController((GeoAnimatable)this, NEEDLE_CONTROLLER, 1, event -> PlayState.CONTINUE);
        InjectorAnimation.registerTriggerableAnimations((AnimationController<InjectorItem>)mainController);
        controllers.add(new AnimationController[]{needleController});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    void broadcastAnimation(ServerLevel level, Player player, ItemStack stack, InjectorAnimation state) {
        long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)level);
        this.triggerAnim((Entity)player, id, state.controller, state.name);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        Serum serum;
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add(ComponentUtil.emptyLine());
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(INVENTORY_TAG) && !(serum = this.getSerum(stack)).isEmpty()) {
            short amount = tag.m_128469_(INVENTORY_TAG).m_128448_("ItemAmount");
            tooltip.add((Component)ComponentUtil.literal(String.format("%dx ", amount)).m_7220_((Component)serum.getDisplayName()).m_130940_(ChatFormatting.GRAY));
            serum.appendTooltip(stack, level, tooltip, isAdvanced);
            tooltip.add(ComponentUtil.emptyLine());
        }
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action.open_inventory")).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getShiftKey().m_130946_(" + ").m_7220_((Component)ClientTextUtil.getRightMouseKey()), TextComponentUtil.getTooltipText("action.self_inject")).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        Serum serum = this.getSerum(stack);
        return serum.isEmpty() ? displayName : ComponentUtil.mutable().m_7220_(displayName).m_130946_(" (").m_7220_((Component)serum.getDisplayName()).m_130946_(")");
    }

    static enum InjectorAnimation {
        INJECT_OTHER("main", "inject", RawAnimation.begin().thenPlay("injector.inject")),
        INJECT_SELF("main", "inject_self", RawAnimation.begin().thenPlay("injector.inject_self")),
        INJECT_FAIL("main", "inject_fail", RawAnimation.begin().thenPlay("injector.inject_fail")),
        REGROW_NEEDLE("needle", "regrow_needle", RawAnimation.begin().thenPlay("injector.regrow_needle"));

        private final String controller;
        private final String name;
        private final RawAnimation rawAnimation;

        private InjectorAnimation(String controller, String name, RawAnimation rawAnimation) {
            this.controller = controller;
            this.name = name;
            this.rawAnimation = rawAnimation;
        }

        public static void registerTriggerableAnimations(AnimationController<InjectorItem> controller) {
            for (InjectorAnimation injectorAnimation : InjectorAnimation.values()) {
                if (!injectorAnimation.controller.equals(controller.getName())) continue;
                controller.triggerableAnim(injectorAnimation.name, injectorAnimation.rawAnimation);
            }
        }
    }

    private static class InventoryCapability
    implements ICapabilityProvider {
        private final InjectorItemInventory itemHandler;

        public InventoryCapability(ItemStack stack) {
            this.itemHandler = InjectorItemInventory.create((short)16, stack);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
            return ModCapabilities.ITEM_HANDLER.orEmpty(capability, this.itemHandler.getLazyOptional());
        }
    }
}

