/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.extractor;

import com.github.elenterius.biomancy.client.render.item.extractor.ExtractorRenderer;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModEnchantments;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.item.KeyPressListener;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.CombatUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExtractorItem
extends Item
implements KeyPressListener,
ItemTooltipStyleProvider,
GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ExtractorItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean tryExtractEssence(ServerLevel level, BlockPos pos, ItemStack stack) {
        List entities = level.m_6443_(LivingEntity.class, new AABB(pos), EntitySelector.f_20408_);
        if (!entities.isEmpty() && ExtractorItem.extractEssence(stack, null, (LivingEntity)entities.get(0))) {
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.INJECTOR_INJECT.get(), SoundSource.BLOCKS, 0.8f, 1.0f / (level.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
            return true;
        }
        return false;
    }

    private static boolean extractEssence(ItemStack stack, @Nullable Player player, LivingEntity targetEntity) {
        if (targetEntity.m_6084_() && !targetEntity.m_21023_((MobEffect)ModMobEffects.ESSENCE_ANEMIA.get())) {
            if (CombatUtil.canPierceThroughArmor(stack, targetEntity, (LivingEntity)player)) {
                int lootingLevel = stack.getEnchantmentLevel(Enchantments.f_44982_);
                int surgicalPrecisionLevel = stack.getEnchantmentLevel((Enchantment)ModEnchantments.SURGICAL_PRECISION.get());
                ItemStack essenceStack = EssenceItem.fromEntity(targetEntity, surgicalPrecisionLevel, lootingLevel);
                if (!essenceStack.m_41619_()) {
                    float damage;
                    if (player != null) {
                        if (!player.m_36356_(essenceStack)) {
                            player.m_36176_(essenceStack, false);
                        }
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
                    } else {
                        Containers.m_18992_((Level)targetEntity.m_9236_(), (double)targetEntity.m_20185_(), (double)targetEntity.m_20186_(), (double)targetEntity.m_20189_(), (ItemStack)essenceStack);
                    }
                    float damagePct = 1.0f;
                    for (ItemStack itemStack : targetEntity.m_6168_()) {
                        AcolyteArmorItem armor;
                        Item item = itemStack.m_41720_();
                        if (!(item instanceof AcolyteArmorItem) || !(armor = (AcolyteArmorItem)item).hasNutrients(itemStack)) continue;
                        damagePct -= 0.25f;
                    }
                    if (stack.getEnchantmentLevel((Enchantment)ModEnchantments.ANESTHETIC.get()) <= 0 && (damage = 0.5f * damagePct) > 0.0f) {
                        targetEntity.m_6469_(targetEntity.m_9236_().m_269111_().m_269396_((LivingEntity)player), damage);
                    }
                    targetEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ESSENCE_ANEMIA.get(), 2400 * (lootingLevel + 1)));
                    return true;
                }
            } else if (player != null) {
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return false;
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        if (!this.interactWithPlayerSelf(stack, player)) {
            SoundUtil.clientPlayItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.INJECTOR_FAIL.get());
            return InteractionResultHolder.m_19100_((Object)flags);
        }
        return InteractionResultHolder.m_19090_((Object)flags);
    }

    @Override
    public void onServerReceiveKeyPress(ItemStack stack, ServerLevel level, Player player, byte flags) {
        boolean hasInteracted = this.interactWithPlayerSelf(stack, player);
        SoundUtil.broadcastItemSound(level, (LivingEntity)player, hasInteracted ? (SoundEvent)ModSoundEvents.INJECTOR_INJECT.get() : (SoundEvent)ModSoundEvents.INJECTOR_FAIL.get());
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = interactionTarget.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ExtractorItem.extractEssence(stack, player, interactionTarget)) {
                SoundUtil.broadcastItemSound(serverLevel, (LivingEntity)player, (SoundEvent)ModSoundEvents.INJECTOR_INJECT.get());
                if (player.m_7500_()) {
                    player.m_21008_(usedHand, stack);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean interactWithPlayerSelf(ItemStack stack, Player player) {
        if (player.m_21023_((MobEffect)ModMobEffects.ESSENCE_ANEMIA.get())) {
            return false;
        }
        if (player.m_9236_().m_5776_()) {
            return true;
        }
        if (ExtractorItem.extractEssence(stack, player, (LivingEntity)player)) {
            if (player.m_7500_()) {
                player.m_21008_(player.m_7655_(), stack);
            }
            return true;
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44982_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return 15;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action.self_extract")).m_130940_(ChatFormatting.DARK_GRAY));
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final ExtractorRenderer renderer = new ExtractorRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            boolean isPlayerLookingAtMob;
            if (state.isCurrentAnimation(Animations.EXTRACT) && state.getController().isPlayingTriggeredAnimation()) {
                return PlayState.CONTINUE;
            }
            boolean isFirstPerson = ((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).m_269069_();
            boolean bl = isPlayerLookingAtMob = isFirstPerson && Minecraft.m_91087_().f_91076_ instanceof LivingEntity;
            if (isPlayerLookingAtMob) {
                state.setAnimation(Animations.TRANSITION_TO_ARMED);
            } else {
                state.setAnimation(Animations.TRANSITION_TO_IDLE);
            }
            return PlayState.CONTINUE;
        });
        controller.setAnimation(Animations.IDLE);
        registrar.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class Animations {
        public static final RawAnimation TRANSITION_TO_IDLE = RawAnimation.begin().thenPlay("extractor.transition_to_idle").thenPlay("extractor.idle");
        public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("extractor.idle");
        public static final RawAnimation TRANSITION_TO_ARMED = RawAnimation.begin().thenPlay("extractor.transition_to_armed").thenPlay("extractor.armed");
        public static final RawAnimation ARMED = RawAnimation.begin().thenPlay("extractor.armed");
        public static final RawAnimation EXTRACT = RawAnimation.begin().thenPlay("extractor.extract");

        private Animations() {
        }
    }
}

