/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.armor;

import com.github.elenterius.biomancy.client.render.item.armor.AcolyteArmorRenderer;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.item.ShowKnowledgeOverlay;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorUpgrades;
import com.github.elenterius.biomancy.item.armor.AdaptiveDamageResistanceHandler;
import com.github.elenterius.biomancy.item.armor.LivingArmorGeoItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public final class AcolyteArmorItem
extends LivingArmorGeoItem
implements ShowKnowledgeOverlay,
ItemTooltipStyleProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AcolyteArmorItem(ArmorMaterial material, ArmorItem.Type type, int maxNutrients, Item.Properties properties) {
        super(material, type, maxNutrients, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new AcolyteArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, slot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public boolean canShowKnowledgeOverlay(ItemStack stack, Player player) {
        return AcolyteArmorUpgrades.hasUpgrade(stack, AcolyteArmorUpgrades.PRIMORDIAL_SIGHT) && this.hasNutrients(stack);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AdaptiveDamageResistanceHandler.DamageTypeResistanceTracker getDamageTypeResistanceTracker(ItemStack stack) {
        CompoundTag tag = stack.m_41784_().m_128469_("damage_resistance_tracker");
        return AdaptiveDamageResistanceHandler.DamageTypeResistanceTracker.fromNBT(tag);
    }

    public void saveDamageTypeResistanceTracker(AdaptiveDamageResistanceHandler.DamageTypeResistanceTracker resistanceTracker, ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128365_("damage_resistance_tracker", (Tag)resistanceTracker.toNBT());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        AcolyteArmorUpgrades.appendHoverText(stack, tooltip);
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)TextComponentUtil.getAbilityText("fleshkin_affinity").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText("fleshkin_affinity.desc")).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)TextComponentUtil.getAbilityText("bio_alchemical_epidermis").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText("bio_alchemical_epidermis.desc")).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add(ComponentUtil.emptyLine());
        CompoundTag compoundTag = stack.m_41784_().m_128469_("damage_resistance_tracker");
        AdaptiveDamageResistanceHandler.DamageTypeResistanceTracker.appendTooltipText(compoundTag, tooltip);
        this.appendLivingToolTooltip(stack, tooltip);
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }
}

