/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public interface ItemCharge {
    public static final String CHARGE_KEY = "Charge";

    default public boolean consumeCharge(ItemStack container, int amount) {
        int charge = this.getCharge(container);
        if (charge < amount) {
            return false;
        }
        this.setCharge(container, charge - amount);
        return true;
    }

    default public boolean addCharge(ItemStack container, int amount) {
        int maxCharge;
        int charge = this.getCharge(container);
        if (charge + amount > (maxCharge = this.getMaxCharge(container))) {
            return false;
        }
        this.setCharge(container, charge + amount);
        return true;
    }

    public int getMaxCharge(ItemStack var1);

    public void onChargeChanged(ItemStack var1, int var2, int var3);

    default public int getCharge(ItemStack container) {
        return container.m_41784_().m_128451_(CHARGE_KEY);
    }

    default public boolean hasCharge(ItemStack container) {
        return this.getCharge(container) > 0;
    }

    default public void setCharge(ItemStack container, int amount) {
        int maxCharge = this.getMaxCharge(container);
        int oldValue = this.getCharge(container);
        int newValue = Mth.m_14045_((int)amount, (int)0, (int)maxCharge);
        container.m_41784_().m_128405_(CHARGE_KEY, newValue);
        this.onChargeChanged(container, oldValue, newValue);
    }

    default public float getChargePct(ItemStack container) {
        return (float)this.getCharge(container) / (float)this.getMaxCharge(container);
    }
}

