/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.client.render.item.guidebook.GuideBookRenderer;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.item.SimpleItem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GuideBookItem
extends SimpleItem
implements GeoItem {
    public static final String MAIN_ANIM_CONTROLLER = "main";
    public static final RawAnimation CLOSED_IDLE_ANIM = RawAnimation.begin().thenLoop("closed_idle");
    public static final RawAnimation OPEN_THEN_IDLE_ANIM = RawAnimation.begin().thenPlay("opening").thenLoop("open_idle");
    public static final RawAnimation CLOSE_THEN_IDLE_ANIM = RawAnimation.begin().thenPlay("closing").thenLoop("closed_idle");
    public static final ResourceLocation GUIDE_BOOK_ID = BiomancyMod.createRL("guide_book");
    protected static final String BOOK_OPEN_KEY = "IsBookOpen";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GuideBookItem(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final GuideBookRenderer renderer = new GuideBookRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (level.f_46443_) {
            this.tryToOpenClientScreen(player);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tryToOpenClientScreen(Player player) {
        boolean canOpenBook = ModsCompatHandler.getModonomiconHelper().openBook(GUIDE_BOOK_ID);
        if (!canOpenBook && player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            Minecraft.m_91087_().m_91152_((Screen)new AdvancementsScreen(localPlayer.f_108617_.m_105145_()));
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        boolean isBookOpen = tag.m_128471_(BOOK_OPEN_KEY);
        if (isSelected) {
            if (!isBookOpen) {
                GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level));
                tag.m_128379_(BOOK_OPEN_KEY, true);
            }
        } else if (isBookOpen) {
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level));
            tag.m_128379_(BOOK_OPEN_KEY, false);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        if (itemEntity.m_9236_().f_46443_) {
            return super.onEntityItemUpdate(stack, itemEntity);
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(BOOK_OPEN_KEY)) {
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)itemEntity.m_9236_()));
            tag.m_128379_(BOOK_OPEN_KEY, false);
            itemEntity.m_32045_(stack.m_41777_());
        }
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    private PlayState handleAnimation(AnimationState<GuideBookItem> state) {
        AnimationController controller = state.getController();
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        boolean isBookOpen = stack.m_41784_().m_128471_(BOOK_OPEN_KEY);
        if (isBookOpen) {
            controller.setAnimation(OPEN_THEN_IDLE_ANIM);
        } else {
            controller.setAnimation(CLOSE_THEN_IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, MAIN_ANIM_CONTROLLER, 10, this::handleAnimation);
        controller.setAnimation(CLOSED_IDLE_ANIM);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

