/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.item.SimpleItem;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GiftSacItem
extends SimpleItem {
    protected static final String ITEMS_KEY = "Items";

    public GiftSacItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (GiftSacItem.dropItems(stack.m_41784_(), player)) {
            player.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + level.m_213780_().m_188501_() * 0.4f);
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    private static boolean dropItems(CompoundTag tag, Player player) {
        if (!tag.m_128441_(ITEMS_KEY)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag list = tag.m_128437_(ITEMS_KEY, 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                if (stack.m_41619_() || player.m_36356_(stack)) continue;
                player.m_36176_(stack, true);
            }
        }
        return true;
    }

    public static ItemStack createFromItems(Item giftBag, List<ItemStack> items) {
        ItemStack stack = new ItemStack((ItemLike)giftBag);
        if (items.isEmpty()) {
            return stack;
        }
        CompoundTag tag = stack.m_41784_();
        ListTag list = new ListTag();
        for (ItemStack item : items) {
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            list.add((Object)itemTag);
        }
        tag.m_128365_(ITEMS_KEY, (Tag)list);
        return stack;
    }

    public static ItemStack createFromItemTags(Item giftBag, List<CompoundTag> items) {
        ItemStack stack = new ItemStack((ItemLike)giftBag);
        if (items.isEmpty()) {
            return stack;
        }
        CompoundTag tag = stack.m_41784_();
        ListTag list = new ListTag();
        list.addAll(items);
        tag.m_128365_(ITEMS_KEY, (Tag)list);
        return stack;
    }

    public static ItemStack createFromListTag(Item giftBag, ListTag contents) {
        ItemStack stack = new ItemStack((ItemLike)giftBag);
        if (contents.isEmpty()) {
            return stack;
        }
        if (contents.m_7264_() != 10) {
            return stack;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(ITEMS_KEY, (Tag)contents.m_6426_());
        return stack;
    }
}

