/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.block.property.MobSoundType;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.MobSoundUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.Nullable;

public class EssenceItem
extends Item
implements ItemTooltipStyleProvider {
    public static final String ENTITY_TYPE_KEY = "entity_type";
    public static final String ESSENCE_DATA_KEY = "essence_data";
    public static final String COLORS_KEY = "colors";
    public static final String SOUNDS_KEY = "sounds";
    public static final String ENTITY_NAME_KEY = "name";
    public static final String ENTITY_UUID_KEY = "entity_uuid";
    public static final String ESSENCE_TIER_KEY = "essence_tier";
    public static final String PLAYER_NAME_KEY = "player_name";

    public EssenceItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack fromEntity(LivingEntity livingEntity, int surgicalPrecisionLevel, int lootingLevel) {
        ItemStack stack;
        int count = 1 + livingEntity.m_217043_().m_216339_(0, 1 + lootingLevel);
        int essenceTier = 1 + livingEntity.m_217043_().m_216339_(0, 1 + surgicalPrecisionLevel);
        EssenceItem essenceItem = (EssenceItem)ModItems.ESSENCE.get();
        if (essenceItem.setEssenceData(stack = new ItemStack((ItemLike)essenceItem, count), essenceTier = Mth.m_14045_((int)essenceTier, (int)1, (int)3), livingEntity)) {
            if (essenceTier >= 3 && livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                stack.m_41784_().m_128359_(PLAYER_NAME_KEY, player.m_36316_().getName());
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack fromEntityType(EntityType<?> entityType, UUID entityUUID) {
        return EssenceItem.fromEntityType(entityType, entityUUID, 3);
    }

    public static ItemStack fromEntityType(EntityType<?> entityType, int essenceTier) {
        return EssenceItem.fromEntityType(entityType, null, Mth.m_14045_((int)essenceTier, (int)1, (int)3));
    }

    private static ItemStack fromEntityType(EntityType<?> entityType, @Nullable UUID entityUUID, int essenceTier) {
        int[] colors;
        ItemStack stack;
        EssenceItem essenceItem = (EssenceItem)ModItems.ESSENCE.get();
        if (essenceItem.setEssenceData(stack = new ItemStack((ItemLike)essenceItem, 1), essenceTier, entityType, null, colors = EssenceItem.getEssenceColors(entityType, entityUUID, essenceTier), null)) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static int[] getEssenceColors(LivingEntity livingEntity, int tier) {
        return EssenceItem.getEssenceColors(livingEntity.m_6095_(), livingEntity.m_20148_(), tier);
    }

    public static int[] getEssenceColors(EntityType<?> entityType, @Nullable UUID entityUUID, int tier) {
        if (entityType == EntityType.f_20532_ && entityUUID != null && tier >= 3) {
            return EssenceItem.getEssenceColors(entityUUID);
        }
        return EssenceItem.getEssenceColors(entityType);
    }

    public static int[] getEssenceColors(UUID uuid) {
        int background = (int)(uuid.getMostSignificantBits() & 0xFFFFFFL);
        int highlight = (int)(uuid.getLeastSignificantBits() & 0xFFFFFFL);
        return new int[]{background, highlight};
    }

    public static int[] getEssenceColors(EntityType<?> entityType) {
        if (entityType == EntityType.f_20532_) {
            return new int[]{44975, 4602533};
        }
        SpawnEggItem spawnEggItem = ForgeSpawnEggItem.fromEntityType(entityType);
        if (spawnEggItem != null) {
            int background = spawnEggItem.m_43211_(0);
            int highlight = spawnEggItem.m_43211_(1);
            return new int[]{background, highlight};
        }
        ResourceLocation key = EntityType.m_20613_(entityType);
        int background = key.hashCode() & 0xFFFFFF;
        int highlight = key.toString().hashCode() & 0xFFFFFF;
        return new int[]{background, highlight};
    }

    public boolean isValidSamplingTarget(LivingEntity livingEntity) {
        return true;
    }

    public boolean setEssenceData(ItemStack stack, int tier, LivingEntity livingEntity) {
        boolean isValidEntity;
        boolean bl = isValidEntity = livingEntity.m_6084_() && this.isValidSamplingTarget(livingEntity);
        if (!isValidEntity) {
            return false;
        }
        UUID entityUUID = tier >= 3 ? livingEntity.m_20148_() : null;
        int[] colors = EssenceItem.getEssenceColors(livingEntity, tier);
        CompoundTag mobSounds = MobSoundUtil.saveSounds(livingEntity);
        return this.setEssenceData(stack, tier, livingEntity.m_6095_(), entityUUID, colors, mobSounds);
    }

    public boolean setEssenceData(ItemStack stack, int tier, EntityType<?> entityType, @Nullable UUID entityUUID, int[] colors, @Nullable CompoundTag mobSounds) {
        if (entityType != EntityType.f_20532_ && !entityType.m_20584_()) {
            return false;
        }
        ResourceLocation entityTypeId = EntityType.m_20613_(entityType);
        CompoundTag essenceTag = new CompoundTag();
        essenceTag.m_128359_(ENTITY_TYPE_KEY, entityTypeId.toString());
        essenceTag.m_128359_(ENTITY_NAME_KEY, entityType.m_20675_());
        if (entityUUID != null) {
            essenceTag.m_128362_(ENTITY_UUID_KEY, entityUUID);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(ESSENCE_DATA_KEY, (Tag)essenceTag);
        tag.m_128385_(COLORS_KEY, colors);
        tag.m_128405_(ESSENCE_TIER_KEY, tier);
        if (mobSounds != null) {
            tag.m_128365_(SOUNDS_KEY, (Tag)mobSounds);
        }
        return true;
    }

    public boolean isValid(ItemStack stack) {
        return this.getEntityType(stack).isPresent();
    }

    public Optional<EntityType<?>> getEntityType(ItemStack stack) {
        CompoundTag tag = stack.m_41784_().m_128469_(ESSENCE_DATA_KEY);
        return EntityType.m_20632_((String)tag.m_128461_(ENTITY_TYPE_KEY));
    }

    public Optional<UUID> getEntityUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41784_().m_128469_(ESSENCE_DATA_KEY);
        if (tag.m_128403_(ENTITY_UUID_KEY)) {
            return Optional.of(tag.m_128342_(ENTITY_UUID_KEY));
        }
        return Optional.empty();
    }

    public Optional<SoundEvent> getMobSound(ItemStack stack, MobSoundType soundType) {
        CompoundTag tag = stack.m_41784_().m_128469_(SOUNDS_KEY);
        return Optional.ofNullable(MobSoundUtil.getSound(tag, soundType));
    }

    public int getColor(ItemStack stack, int tintIndex) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(COLORS_KEY, 11)) {
            int[] colors = tag.m_128465_(COLORS_KEY);
            return tintIndex == 0 ? colors[0] : colors[1];
        }
        return -1;
    }

    public int[] getColors(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(COLORS_KEY, 11)) {
            return tag.m_128465_(COLORS_KEY);
        }
        return new int[]{-1, -1};
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        CompoundTag tag;
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add(ComponentUtil.emptyLine());
        CompoundTag compoundTag = stack.m_41784_();
        if (compoundTag.m_128441_(ESSENCE_DATA_KEY) && (tag = compoundTag.m_128469_(ESSENCE_DATA_KEY)).m_128403_(ENTITY_UUID_KEY)) {
            UUID entityUUID = tag.m_128342_(ENTITY_UUID_KEY);
            if (tag.m_128461_(ENTITY_NAME_KEY).equals(EntityType.f_20532_.m_20675_()) && compoundTag.m_128441_(PLAYER_NAME_KEY)) {
                String name = compoundTag.m_128461_(PLAYER_NAME_KEY);
                tooltip.add((Component)ComponentUtil.literal("Player: " + name).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)ComponentUtil.literal("UUID: " + entityUUID).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add(ComponentUtil.emptyLine());
        }
        int tier = compoundTag.m_128451_(ESSENCE_TIER_KEY);
        tooltip.add((Component)ComponentUtil.literal("Tier: " + tier));
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        if (!compoundTag.m_128441_(ESSENCE_DATA_KEY)) {
            return Component.m_237115_((String)this.m_5671_(stack));
        }
        CompoundTag tag = compoundTag.m_128469_(ESSENCE_DATA_KEY);
        MutableComponent entityName = ComponentUtil.translatable(tag.m_128461_(ENTITY_NAME_KEY));
        if (tag.m_128403_(ENTITY_UUID_KEY)) {
            return Component.m_237110_((String)(this.m_5671_(stack) + ".unique_mob"), (Object[])new Object[]{entityName});
        }
        return Component.m_237110_((String)(this.m_5671_(stack) + ".mob"), (Object[])new Object[]{entityName});
    }
}

