/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class ItemHandlerUtil {
    private ItemHandlerUtil() {
    }

    public static void dropContents(Level level, BlockPos pos, IItemHandler itemHandler) {
        ItemHandlerUtil.dropContents(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), itemHandler);
    }

    public static void dropContents(Level level, Entity entity, IItemHandler itemHandler) {
        ItemHandlerUtil.dropContents(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemHandler);
    }

    public static void dropContents(Level level, double x, double y, double z, IItemHandler itemHandler) {
        if (level.m_5776_()) {
            return;
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)itemHandler.extractItem(slot, Integer.MAX_VALUE, false));
        }
    }

    public static boolean doesItemFit(IItemHandler itemHandler, int index, ItemStack stack) {
        if (!itemHandler.isItemValid(index, stack)) {
            return false;
        }
        ItemStack remainder = itemHandler.insertItem(index, stack, true);
        return remainder.m_41619_();
    }

    public static boolean doesItemFit(IItemHandler itemHandler, ItemStack stack) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.isItemValid(i, stack) || !(stack = itemHandler.insertItem(i, stack, true)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack insertItem(IItemHandler itemHandler, int slot, ItemStack stack) {
        return itemHandler.insertItem(slot, stack, false);
    }

    public static ItemStack insertItem(IItemHandler itemHandler, ItemStack stack) {
        return ItemHandlerUtil.insertItem(itemHandler, stack, false);
    }

    public static ItemStack insertItem(IItemHandler itemHandler, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!(stack = itemHandler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static boolean doAllItemsFit(IItemHandler itemHandler, List<ItemStack> items) {
        InsertSimulation simulation = new InsertSimulation(itemHandler);
        return simulation.insertAllItems(items);
    }

    private static class InsertSimulation {
        private final IItemHandler itemHandler;
        int slots;
        int[] availableSlotSpace;
        ItemStack[] itemInSlot;

        private InsertSimulation(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
            this.slots = itemHandler.getSlots();
            this.availableSlotSpace = new int[this.slots];
            this.itemInSlot = new ItemStack[this.slots];
            for (int i = 0; i < this.slots; ++i) {
                ItemStack stack;
                this.itemInSlot[i] = stack = itemHandler.getStackInSlot(i);
                this.availableSlotSpace[i] = itemHandler.getSlotLimit(i) - stack.m_41613_();
            }
        }

        private boolean canInsertItem(int index, ItemStack stack) {
            if (stack.m_41619_() || this.availableSlotSpace[index] <= 0) {
                return false;
            }
            if (!this.itemHandler.isItemValid(index, stack)) {
                return false;
            }
            if (this.itemInSlot[index].m_41619_()) {
                return true;
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.itemInSlot[index]);
        }

        private ItemStack insertItem(int index, ItemStack stack) {
            if (!this.canInsertItem(index, stack)) {
                return stack;
            }
            int insertAmount = Math.min(this.availableSlotSpace[index], stack.m_41613_());
            int n = index;
            this.availableSlotSpace[n] = this.availableSlotSpace[n] - insertAmount;
            if (this.itemInSlot[index].m_41619_()) {
                this.itemInSlot[index] = stack;
            }
            return stack.m_255036_(stack.m_41613_() - insertAmount);
        }

        private boolean insertAllItems(List<ItemStack> items) {
            for (ItemStack stack : items) {
                if (stack.m_41619_()) continue;
                for (int i = 0; i < this.slots; ++i) {
                    stack = this.insertItem(i, stack);
                }
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }
    }
}

