/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.inventory.SerializableItemHandler;
import com.github.elenterius.biomancy.util.ItemStackFilter;
import com.github.elenterius.biomancy.util.ItemStackFilterList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BehavioralItemHandler
extends IItemHandler {
    public IItemHandler withoutBehavior();

    public static class LockableItemStackFilterInput
    extends ItemStackFilterInput {
        private boolean locked = false;

        public LockableItemStackFilterInput(SerializableItemHandler itemHandler) {
            super(itemHandler);
        }

        public void toggleLock() {
            this.setLocked(!this.locked);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
            if (locked) {
                for (int i = 0; i < ((SerializableItemHandler)this.itemHandler).getSlots(); ++i) {
                    ItemStack stack = ((SerializableItemHandler)this.itemHandler).getStackInSlot(i);
                    this.filters.set(i, ItemStackFilter.of(stack));
                }
            } else {
                this.filters.setAllFilters(ItemStackFilter.ALLOW_ANY);
            }
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128379_("Locked", this.locked);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            this.locked = tag.m_128471_("Locked");
        }
    }

    public static class ItemStackFilterInput
    extends Wrapper<SerializableItemHandler>
    implements SerializableItemHandler {
        protected final ItemStackFilterList filters;

        public ItemStackFilterInput(SerializableItemHandler itemHandler) {
            super(itemHandler);
            this.filters = ItemStackFilterList.of(ItemStackFilter.ALLOW_ANY, itemHandler.getSlots());
        }

        private boolean isInvalidSlot(int slot) {
            return slot < 0 || slot >= this.filters.size();
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.isInvalidSlot(slot)) {
                return false;
            }
            return this.filters.get(slot).test(stack) && ((SerializableItemHandler)this.itemHandler).isItemValid(slot, stack);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.isInvalidSlot(slot)) {
                return stack;
            }
            if (!this.filters.get(slot).test(stack)) {
                return stack;
            }
            return ((SerializableItemHandler)this.itemHandler).insertItem(slot, stack, simulate);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Handler", ((SerializableItemHandler)this.itemHandler).serializeNBT());
            tag.m_128365_("Filters", (Tag)this.filters.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            ((SerializableItemHandler)this.itemHandler).deserializeNBT((Tag)tag.m_128469_("Handler"));
            this.filters.deserializeNBT(tag.m_128437_("Filters", 10));
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ((SerializableItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }

        @Nullable
        public ItemStack getFilterItemStack(int slot) {
            return this.filters.get(slot).getItemStack();
        }

        public void setFilters(List<ItemStack> filters) {
            for (int i = 0; i < ((SerializableItemHandler)this.itemHandler).getSlots(); ++i) {
                this.filters.set(i, ItemStackFilter.of(filters.get(i)));
            }
        }

        public ItemStackFilterList getFilters() {
            return this.filters;
        }
    }

    public static class PredicateFilterInput
    extends Wrapper<SerializableItemHandler>
    implements SerializableItemHandler {
        protected final List<Predicate<ItemStack>> filters;

        public PredicateFilterInput(SerializableItemHandler itemHandler, List<Predicate<ItemStack>> slotFilters) {
            super(itemHandler);
            assert (slotFilters.size() == itemHandler.getSlots());
            this.filters = slotFilters;
        }

        private boolean isInvalidSlot(int slot) {
            return slot < 0 || slot >= this.filters.size();
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (this.isInvalidSlot(slot)) {
                return false;
            }
            return this.filters.get(slot).test(stack) && ((SerializableItemHandler)this.itemHandler).isItemValid(slot, stack);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isInvalidSlot(slot)) {
                return stack;
            }
            if (!this.filters.get(slot).test(stack)) {
                return stack;
            }
            return ((SerializableItemHandler)this.itemHandler).insertItem(slot, stack, simulate);
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)((SerializableItemHandler)this.itemHandler).serializeNBT();
        }

        public void deserializeNBT(CompoundTag tag) {
            ((SerializableItemHandler)this.itemHandler).deserializeNBT((Tag)tag);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            ((SerializableItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }
    }

    public static class DenyInput
    extends Wrapper<SerializableItemHandler>
    implements SerializableItemHandler {
        public DenyInput(SerializableItemHandler itemHandler) {
            super(itemHandler);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)((SerializableItemHandler)this.itemHandler).serializeNBT();
        }

        public void deserializeNBT(CompoundTag tag) {
            ((SerializableItemHandler)this.itemHandler).deserializeNBT((Tag)tag);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            ((SerializableItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }
    }

    public static abstract class Wrapper<T extends IItemHandler>
    implements BehavioralItemHandler {
        protected final T itemHandler;

        public Wrapper(T itemHandler) {
            this.itemHandler = itemHandler;
        }

        @Override
        public IItemHandler withoutBehavior() {
            return this.itemHandler;
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.itemHandler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.itemHandler.isItemValid(slot, stack);
        }
    }
}

