/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlock;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.item.BEWLBlockItem;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorUpgrades;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public final class SpecialCraftingRecipeMaker {
    private SpecialCraftingRecipeMaker() {
    }

    public static List<CraftingRecipe> createCradleCleansingRecipes() {
        ItemStack cradle = ((BEWLBlockItem)ModItems.PRIMORDIAL_CRADLE.get()).m_7968_();
        CompoundTag tag = new CompoundTag();
        CompoundTag tagProcGen = new CompoundTag();
        MoundShape.ProcGenValues procGenValues = new MoundShape.ProcGenValues(1234L, 0, 0, 1, 250, 66, 0.7f, 0.5f);
        procGenValues.writeTo(tagProcGen);
        tag.m_128365_("ProcGenValues", (Tag)tagProcGen);
        BlockItem.m_186338_((ItemStack)cradle, (BlockEntityType)((BlockEntityType)ModBlockEntities.PRIMORDIAL_CRADLE.get()), (CompoundTag)tag);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{cradle}));
        ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CLEANSING_SERUM.get()}));
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        ResourceLocation recipeId = ModItems.PRIMORDIAL_CRADLE.getId().m_266382_("_cleansing.cleansed");
        ItemStack result = ((BEWLBlockItem)ModItems.PRIMORDIAL_CRADLE.get()).m_7968_();
        return List.of(new ShapelessRecipe(recipeId, "", CraftingBookCategory.MISC, result, inputs));
    }

    public static List<CraftingRecipe> createAcolyteHelmetUpgradeRecipes() {
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PRIMORDIAL_CORE.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ACOLYTE_ARMOR_HELMET.get()})});
        ItemStack result = AcolyteArmorUpgrades.addUpgrade(((AcolyteArmorItem)ModItems.ACOLYTE_ARMOR_HELMET.get()).m_7968_(), AcolyteArmorUpgrades.PRIMORDIAL_SIGHT);
        return List.of(new ShapelessRecipe(BiomancyMod.createRL("special_crafting/acolyte_helmet_upgrade"), "", CraftingBookCategory.MISC, result, inputs));
    }

    public static List<CraftingRecipe> createPlayerHeadRecipes() {
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42680_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.EXOTIC_DUST.get()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{SpecialCraftingRecipeMaker.createUniquePlayerEssence(UUID.fromString("853c80ef-3c37-49fd-aa49-938b674adae6"), "jeb_")})});
        ItemStack result = SpecialCraftingRecipeMaker.createPlayerHead("jeb_");
        return List.of(new ShapelessRecipe(BiomancyMod.createRL("special_crafting/player_head"), "", CraftingBookCategory.MISC, result, inputs));
    }

    private static ItemStack createPlayerHead(String name) {
        GameProfile gameProfile = new GameProfile(null, name);
        ItemStack stack = Items.f_42680_.m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameProfile));
        return stack;
    }

    private static ItemStack createUniquePlayerEssence(UUID entityUUID, String playerName) {
        ItemStack stack = ((EssenceItem)ModItems.ESSENCE.get()).m_7968_();
        CompoundTag tag = stack.m_41784_();
        EntityType entityType = EntityType.f_20532_;
        int[] colors = EssenceItem.getEssenceColors(entityUUID);
        CompoundTag essenceTag = new CompoundTag();
        essenceTag.m_128359_("entity_type", EntityType.m_20613_((EntityType)entityType).toString());
        essenceTag.m_128359_("name", entityType.m_20675_());
        essenceTag.m_128362_("entity_uuid", entityUUID);
        tag.m_128365_("essence_data", (Tag)essenceTag);
        tag.m_128405_("essence_tier", 3);
        tag.m_128385_("colors", colors);
        tag.m_128359_("player_name", playerName);
        return stack;
    }

    public static List<CraftingRecipe> createBiometricMembraneRecipes() {
        UUID pigUUID = UUID.fromString("420faf42-bf42-4b20-af42-c42420e42d42");
        UUID playerUUID = UUID.fromString("853c80ef-3c37-49fd-aa49-938b674adae6");
        String playerName = "jeb_";
        Stream<CraftingRecipe[]> recipePairs = Stream.of(SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20510_, false, null), SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20510_, true, null), SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20510_, false, pigUUID), SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20510_, true, pigUUID), SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20532_, false, null), SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20532_, true, null), SpecialCraftingRecipeMaker.createUniquePlayerRecipePair(false, playerUUID, playerName), SpecialCraftingRecipeMaker.createUniquePlayerRecipePair(true, playerUUID, playerName));
        return recipePairs.flatMap(Stream::of).toList();
    }

    private static CraftingRecipe[] createUniquePlayerRecipePair(boolean isInverted, UUID playerUUID, String playerName) {
        Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{SpecialCraftingRecipeMaker.createUniquePlayerEssence(playerUUID, playerName)});
        return SpecialCraftingRecipeMaker.createRecipePair(EntityType.f_20532_, isInverted, playerUUID, 3, ingredient);
    }

    private static CraftingRecipe[] createRecipePair(EntityType<?> entityType, boolean isInverted, @Nullable UUID entityUUID) {
        int tier = entityUUID != null ? 3 : 1;
        Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{EssenceItem.fromEntityType(entityType, tier)});
        return SpecialCraftingRecipeMaker.createRecipePair(entityType, isInverted, entityUUID, tier, ingredient);
    }

    private static CraftingRecipe[] createRecipePair(EntityType<?> entityType, boolean isInverted, @Nullable UUID entityUUID, int tier, Ingredient essence) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        ingredients.add(essence);
        ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BIOMETRIC_MEMBRANE.get()}));
        if (isInverted) {
            ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41978_}));
        }
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        ItemStack membraneStack = BiometricMembraneBlock.createItem(entityType, entityUUID, EssenceItem.getEssenceColors(entityType, entityUUID, tier), isInverted);
        String name = ModItems.BIOMETRIC_MEMBRANE.getId().m_214298_();
        String inverted = isInverted ? "inverted." : "";
        String unique = entityUUID != null ? "unique." : "";
        ResourceLocation createRecipeId = BiomancyMod.createRL(name + "." + inverted + unique + entityType.m_20675_());
        ResourceLocation resetRecipeId = BiomancyMod.createRL(name + ".reset." + inverted + unique + entityType.m_20675_());
        return new CraftingRecipe[]{new ShapelessRecipe(createRecipeId, name, CraftingBookCategory.MISC, membraneStack, inputs), new ShapelessRecipe(resetRecipeId, name, CraftingBookCategory.MISC, new ItemStack((ItemLike)ModItems.BIOMETRIC_MEMBRANE.get()), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{membraneStack})}))};
    }
}

