/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.ArrayList;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DigestingCategory
implements IRecipeCategory<DigestingRecipe> {
    public static final RecipeType<DigestingRecipe> RECIPE_TYPE = new RecipeType(ModRecipes.DIGESTING_RECIPE_TYPE.getId(), DigestingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final RecipeWrapper inputInventoryWrapper;

    public DigestingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.DIGESTER.get()));
        ResourceLocation texture = BiomancyMod.createRL("textures/gui/jei/digester_recipe.png");
        this.background = guiHelper.drawableBuilder(texture, 0, 0, 80, 47).setTextureSize(80, 47).addPadding(0, 4, 0, 0).build();
        this.inputInventoryWrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    }

    public RecipeType<DigestingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return ComponentUtil.translatable("jei.biomancy.recipe.digester");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DigestingRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        builder.setShapeless();
        if (recipe.m_5598_()) {
            Ingredient ingredient = recipe.getIngredient();
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 4).addIngredients(ingredient);
            ArrayList<ItemStack> possibleOutputs = new ArrayList<ItemStack>();
            for (ItemStack ingredientItem : ingredient.m_43908_()) {
                this.inputInventoryWrapper.m_6836_(0, ingredientItem);
                ItemStack result = recipe.m_5874_((Container)this.inputInventoryWrapper, level.m_9598_());
                possibleOutputs.add(result);
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 5).addItemStacks(possibleOutputs);
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 4).addIngredients(recipe.getIngredient());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 5).addItemStack(recipe.m_8043_(level.m_9598_()));
        }
    }

    public void draw(DigestingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        IRecipeSlotView slotView = (IRecipeSlotView)recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).get(0);
        ItemStack itemStack = slotView.getDisplayedItemStack().orElse(ItemStack.f_41583_);
        this.inputInventoryWrapper.m_6836_(0, itemStack);
        int ticks = recipe.getCraftingTimeTicks((Container)this.inputInventoryWrapper);
        int seconds = ticks > 0 ? ticks / 20 : 0;
        MutableComponent timeText = ComponentUtil.translatable("gui.jei.category.smelting.time.seconds", seconds);
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)timeText, 48, 44 - 9, -1);
        MutableComponent costText = ComponentUtil.literal("-" + recipe.getCraftingCostNutrients((Container)this.inputInventoryWrapper));
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)costText, 15, 44 - 9, -1);
    }
}

