/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.event;

import com.github.elenterius.biomancy.enchantment.ParasiticMetabolismEnchantment;
import com.github.elenterius.biomancy.enchantment.SelfFeedingEnchantment;
import com.github.elenterius.biomancy.init.AcidInteractions;
import com.github.elenterius.biomancy.init.ModEnchantments;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.serum.FrenzySerum;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LivingEventHandler {
    private LivingEventHandler() {
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        AcidInteractions.handleEntityInsideAcidFluid(event.getEntity());
    }

    @SubscribeEvent
    public static void onLivingTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.player.f_19797_ % 30 == 0) {
            ((SelfFeedingEnchantment)((Object)ModEnchantments.SELF_FEEDING.get())).repairLivingItems(event.player);
            ((ParasiticMetabolismEnchantment)((Object)ModEnchantments.PARASITIC_METABOLISM.get())).repairLivingItems(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (livingEntity.m_21023_((MobEffect)ModMobEffects.PRIMORDIAL_INFESTATION.get())) {
                if (livingEntity.m_203117_() || livingEntity.m_6060_()) {
                    return;
                }
                PrimordialEcosystem.placeMalignantBlocksOnLivingDeath(serverLevel, livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (mob = (Mob)entity).m_21023_((MobEffect)ModMobEffects.FRENZY.get())) {
            FrenzySerum.injectAIBehavior(mob);
        }
    }
}

