/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class BaseProjectile
extends Projectile
implements IEntityAdditionalSpawnData {
    public static final float DEFAULT_DRAG = 0.99f;
    public static final float DEFAULT_WATER_DRAG = 0.8f;
    private float damage = 2.0f;
    private byte knockback = 0;

    protected BaseProjectile(EntityType<? extends BaseProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected BaseProjectile(EntityType<? extends BaseProjectile> entityType, Level level, double x, double y, double z) {
        this(entityType, level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity shooter = this.m_19749_();
        buffer.m_130130_(shooter == null ? 0 : shooter.m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        Entity shooter = this.m_9236_().m_6815_(buffer.m_130242_());
        this.m_5602_(shooter);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", this.damage);
        tag.m_128344_("knockback", this.knockback);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.damage = tag.m_128441_("damage") ? tag.m_128457_("damage") : 5.0f;
        this.knockback = tag.m_128445_("knockback");
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damageIn) {
        this.damage = damageIn;
    }

    public byte getKnockback() {
        return this.knockback;
    }

    public void setKnockback(byte knockbackIn) {
        this.knockback = knockbackIn;
    }

    public float getDrag() {
        return 0.99f;
    }

    public float getWaterDrag() {
        return 0.8f;
    }

    public float getGravity() {
        return (float)(((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22082_() / 4.0);
    }

    public void m_8119_() {
        Entity shooter = this.m_19749_();
        if (this.m_9236_().f_46443_ || (shooter == null || !shooter.m_213877_()) && this.m_9236_().isAreaLoaded(this.m_20183_(), 1)) {
            HitResult hitResult;
            super.m_8119_();
            if (this.m_20070_()) {
                this.m_20095_();
            }
            if ((hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
                this.m_6532_(hitResult);
            }
            this.m_20101_();
            Vec3 motion = this.m_20184_();
            double posX = this.m_20185_() + motion.f_82479_;
            double posY = this.m_20186_() + motion.f_82480_;
            double posZ = this.m_20189_() + motion.f_82481_;
            this.m_37283_();
            float drag = this.getDrag();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, posX - motion.f_82479_ * 0.25, posY - motion.f_82480_ * 0.25, posZ - motion.f_82481_ * 0.25, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
                drag = this.getWaterDrag();
            }
            this.m_20256_(motion.m_82490_((double)drag));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-this.getGravity()), 0.0));
            }
            this.spawnParticle(posX, posY, posZ);
            this.m_6034_(posX, posY, posZ);
        } else {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public void spawnParticle(double x, double y, double z) {
        this.m_9236_().m_7106_(this.getParticle(), x, y + 0.5, z, 0.0, 0.0, 0.0);
    }

    protected ParticleOptions getParticle() {
        return ParticleTypes.f_123762_;
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !entity.f_19794_;
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6783_(double distance) {
        double dist = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(dist)) {
            dist = 1.0;
        }
        return distance < (dist = dist * 64.0 * BaseProjectile.m_20150_()) * dist;
    }
}

