/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.projectile;

import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.util.CombatUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class AcidSpitProjectile
extends BaseProjectile {
    public AcidSpitProjectile(EntityType<? extends BaseProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AcidSpitProjectile(Level level, double x, double y, double z) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntityTypes.CORROSIVE_ACID_PROJECTILE.get()), level, x, y, z);
    }

    public AcidSpitProjectile(EntityType<? extends AcidSpitProjectile> entityType, Level level, double x, double y, double z) {
        super(entityType, level, x, y, z);
    }

    @Override
    public float getGravity() {
        return 0.025f;
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.playHitSound();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity victim = result.m_82443_();
            Entity owner = this.m_19749_();
            victim.m_6469_(ModDamageSources.acidProjectile(this.m_9236_(), this, owner), this.getDamage());
            if (victim instanceof LivingEntity) {
                LivingEntity livingVictim = (LivingEntity)victim;
                CombatUtil.applyAcidEffect(livingVictim, 4);
            }
            if (owner instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)owner;
                this.m_19970_(shooter, victim);
            }
        }
        this.playHitSound();
    }

    protected void playHitSound() {
        this.m_5496_(SoundEvents.f_12389_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.f_123764_;
    }
}

