/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.ai.goal;

import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlock;
import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlockEntity;
import com.github.elenterius.biomancy.entity.mob.PrimordialCradleUser;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.util.LevelUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class UsePrimordialCradleGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    public static final int SEARCH_RANGE = 32;
    private final T cradleUser;
    private boolean wantsToUseCradle;
    private boolean canUseCradle;
    private final double maxUseDistance;

    public UsePrimordialCradleGoal(T mob) {
        this(mob, 1.5);
    }

    public UsePrimordialCradleGoal(T mob, double maxUseDistance) {
        super(mob, 1.0, 32, 32);
        this.cradleUser = mob;
        this.maxUseDistance = maxUseDistance;
    }

    public boolean m_8036_() {
        if (this.f_25600_ <= 0) {
            this.canUseCradle = false;
            this.wantsToUseCradle = ((PrimordialCradleUser)this.cradleUser).hasTributeForCradle();
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        return this.canUseCradle && super.m_8045_();
    }

    public void m_8037_() {
        PrimordialCradleBlockEntity cradle;
        BlockEntity blockEntity;
        BlockPos pos;
        Level level;
        BlockState state;
        super.m_8037_();
        if (!this.m_25625_()) {
            return;
        }
        this.cradleUser.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_() + 0.5, (double)this.f_25602_.m_123343_() + 0.5, 20.0f, (float)this.cradleUser.m_8132_());
        if (this.canUseCradle && (state = (level = this.cradleUser.m_9236_()).m_8055_(pos = this.f_25602_)).m_60734_() instanceof PrimordialCradleBlock && (blockEntity = level.m_7702_(pos)) instanceof PrimordialCradleBlockEntity && this.sacrificeItem(level, pos, cradle = (PrimordialCradleBlockEntity)blockEntity, ((PrimordialCradleUser)this.cradleUser).getTributeItemForCradle()) && !cradle.isFull()) {
            this.sacrificeItem(level, pos, cradle, new ItemStack((ItemLike)ModItems.CREATOR_MIX.get(), 5));
        }
        this.canUseCradle = false;
        this.f_25600_ = 10;
    }

    public double m_8052_() {
        return this.maxUseDistance;
    }

    protected boolean m_6465_(LevelReader level, BlockPos pos) {
        PrimordialCradleBlockEntity cradle;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof PrimordialCradleBlock && this.wantsToUseCradle && !this.canUseCradle && (blockEntity = level.m_7702_(pos)) instanceof PrimordialCradleBlockEntity && !(cradle = (PrimordialCradleBlockEntity)blockEntity).isFull()) {
            this.canUseCradle = true;
            return true;
        }
        return false;
    }

    protected boolean m_25626_() {
        PrimordialCradleBlockEntity nearestBlockEntity = LevelUtil.findNearestBlockEntity((ServerLevel)this.f_25598_.m_9236_(), this.f_25598_.m_20183_(), 32, PrimordialCradleBlockEntity.class);
        if (nearestBlockEntity == null) {
            return false;
        }
        BlockPos nearestPos = nearestBlockEntity.m_58899_();
        if (this.f_25598_.m_21444_(nearestPos) && this.m_6465_((LevelReader)this.f_25598_.m_9236_(), nearestPos)) {
            this.f_25602_ = nearestPos;
            return true;
        }
        return false;
    }

    private boolean sacrificeItem(Level level, BlockPos pos, PrimordialCradleBlockEntity cradle, ItemStack stack) {
        if (!cradle.isFull() && cradle.insertItem(stack)) {
            SoundEvent soundEvent = cradle.isFull() ? (SoundEvent)ModSoundEvents.CRADLE_BECAME_FULL.get() : (SoundEvent)ModSoundEvents.CRADLE_EAT.get();
            SoundUtil.broadcastBlockSound((ServerLevel)level, pos, soundEvent);
            return true;
        }
        return false;
    }
}

