/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.ai.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class FindItemGoal
extends Goal {
    public static final Predicate<ItemEntity> ITEM_ENTITY_FILTER = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_();
    protected final Mob mob;
    protected final float searchDistance;
    protected final Predicate<ItemEntity> itemFilter;

    public FindItemGoal(Mob mob) {
        this(mob, 8.0f, ITEM_ENTITY_FILTER);
    }

    public FindItemGoal(Mob mob, float searchDistance) {
        this(mob, searchDistance, ITEM_ENTITY_FILTER);
    }

    public FindItemGoal(Mob mob, float searchDistance, Predicate<ItemEntity> itemFilter) {
        this.mob = mob;
        this.searchDistance = searchDistance;
        this.itemFilter = itemFilter;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean handIsEmpty = this.mob.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        if (!handIsEmpty) {
            return false;
        }
        if (this.mob.m_5448_() == null && this.mob.m_21188_() == null) {
            if (this.mob.m_217043_().m_188503_(10) != 0) {
                return false;
            }
            return !this.findItems(this.searchDistance, this.itemFilter).isEmpty();
        }
        return false;
    }

    public void m_8037_() {
        List<ItemEntity> list;
        ItemStack heldStack = this.mob.m_6844_(EquipmentSlot.MAINHAND);
        if (heldStack.m_41619_() && !(list = this.findItems(this.searchDistance, this.itemFilter)).isEmpty()) {
            this.mob.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
        }
    }

    public void m_8056_() {
        List<ItemEntity> list = this.findItems(this.searchDistance, this.itemFilter);
        if (!list.isEmpty()) {
            this.mob.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
        }
    }

    public List<ItemEntity> findItems(double distance, Predicate<ItemEntity> filter) {
        return this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(distance, distance, distance), filter);
    }
}

