/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class ThickFurSheep
extends Sheep {
    private static final EntityDataAccessor<Byte> WOOL_SIZE = SynchedEntityData.m_135353_(ThickFurSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final byte MAX_WOOL_SIZE = 10;

    public ThickFurSheep(EntityType<? extends Sheep> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WOOL_SIZE, (Object)1);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("WoolSize", (byte)this.getWoolSize());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setWoolSize(compound.m_128445_("WoolSize"));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20390_(1.0f + (float)this.getWoolSize() / 10.0f * 0.5f, 1.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag compound) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, spawnType, data, compound);
        this.setWoolSize(!this.m_29875_() ? (byte)1 : 0);
        return spawnData;
    }

    public int getWoolSize() {
        return ((Byte)this.f_19804_.m_135370_(WOOL_SIZE)).byteValue();
    }

    protected void setWoolSize(byte size) {
        size = (byte)Mth.m_14045_((int)size, (int)0, (int)127);
        this.f_19804_.m_135381_(WOOL_SIZE, (Object)size);
        this.m_20090_();
        this.m_6210_();
        double pct = (double)size / 10.0;
        this.m_21051_(Attributes.f_22279_).m_22100_(0.23 - 0.16 * pct);
        this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22100_(0.08 + 0.16 * pct);
        this.m_21051_(Attributes.f_22284_).m_22100_(Mth.m_14008_((double)(16.0 * pct - 1.6), (double)0.0, (double)16.0));
        this.m_21051_(Attributes.f_22285_).m_22100_(Mth.m_14008_((double)(3.0 * pct - 1.0), (double)0.0, (double)16.0));
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_6034_(x, y, z);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (WOOL_SIZE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_8035_() {
        if (this.m_6162_()) {
            if (this.m_29875_()) {
                this.m_29878_(false);
            } else {
                this.m_146758_(60);
            }
        } else {
            this.m_29878_(false);
        }
    }

    public void m_29878_(boolean sheared) {
        if (sheared) {
            int woolSize = this.getWoolSize() - 1;
            this.setWoolSize((byte)woolSize);
            if (woolSize <= 0) {
                super.m_29878_(true);
            }
        } else {
            int woolSize = this.getWoolSize();
            if (woolSize < 10) {
                this.setWoolSize((byte)(woolSize + 1));
            }
            super.m_29878_(false);
        }
    }

    @Nullable
    public Sheep m_142606_(ServerLevel level, AgeableMob otherParent) {
        float p = (this.m_21023_((MobEffect)ModMobEffects.LIBIDO.get()) ? 0.1f : 0.0f) + (otherParent.m_21023_((MobEffect)ModMobEffects.LIBIDO.get()) ? 0.1f : 0.0f);
        if (p > 0.0f && this.f_19796_.m_188501_() < p) {
            return (Sheep)((EntityType)ModEntityTypes.FLESH_SHEEP.get()).m_20615_((Level)level);
        }
        return (Sheep)((EntityType)ModEntityTypes.THICK_FUR_SHEEP.get()).m_20615_((Level)level);
    }
}

