/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.enchantment;

import com.github.elenterius.biomancy.api.livingtool.LivingTool;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.api.nutrients.NutrientsContainerItem;
import com.github.elenterius.biomancy.init.ModEnchantments;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.util.EnchantmentUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class SelfFeedingEnchantment
extends Enchantment {
    public SelfFeedingEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... applicableSlots) {
        super(rarity, ModEnchantments.LIVING_CATEGORY, applicableSlots);
    }

    public void repairLivingItems(Player player) {
        List<Map.Entry<EquipmentSlot, ItemStack>> enchantedItems = EnchantmentUtil.getItemsWithEnchantment(this, (LivingEntity)player, LivingTool.NEED_NUTRIENTS_PREDICATE);
        if (enchantedItems.isEmpty()) {
            return;
        }
        Map.Entry<EquipmentSlot, ItemStack> slotItem = enchantedItems.get(player.m_217043_().m_188503_(enchantedItems.size()));
        ItemStack stack = slotItem.getValue();
        NutrientsContainerItem nutrientsContainer = (NutrientsContainerItem)stack.m_41720_();
        int neededRepairValue = nutrientsContainer.getMaxNutrients(stack) - nutrientsContainer.getNutrients(stack);
        ItemStack repairItemStack = this.getBestRepairItem(player, neededRepairValue);
        if (repairItemStack.m_41619_()) {
            return;
        }
        nutrientsContainer.increaseNutrients(stack, Nutrients.getRepairValue(repairItemStack));
        if (!player.m_150110_().f_35937_) {
            if (repairItemStack.hasCraftingRemainingItem()) {
                ItemStack craftingRemainder = repairItemStack.getCraftingRemainingItem();
                repairItemStack.m_41774_(1);
                if (!craftingRemainder.m_41619_() && !player.m_36356_(craftingRemainder)) {
                    player.m_36176_(craftingRemainder, false);
                }
            } else {
                repairItemStack.m_41774_(1);
            }
        }
    }

    protected ItemStack getBestRepairItem(Player player, int neededRepairValue) {
        NonNullList items = player.m_150109_().f_35974_;
        ItemStack repairItemStack = ItemStack.f_41583_;
        int minError = Integer.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            int error;
            ItemStack itemStack = (ItemStack)items.get(i);
            int repairValue = Nutrients.getRepairValue(itemStack);
            if (repairValue <= 0) continue;
            Item item = itemStack.m_41720_();
            if (item == ModItems.NUTRIENT_PASTE.get() || item == ModItems.NUTRIENT_BAR.get()) {
                error = repairValue > neededRepairValue ? (repairValue - neededRepairValue) / 2 : -repairValue * 2;
            } else {
                int n = error = repairValue > neededRepairValue ? (repairValue - neededRepairValue) * 2 : -repairValue / 2;
            }
            if (error >= minError) continue;
            minError = error;
            repairItemStack = itemStack;
        }
        return repairItemStack;
    }
}

