/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.datagen.recipes.builder.ItemData;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeBuilder;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeCostUtil;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.Nullable;

public final class BioBrewingRecipeBuilder
implements RecipeBuilder<BioBrewingRecipeBuilder> {
    public static final String RECIPE_SUB_FOLDER = ModRecipes.BIO_BREWING_RECIPE_TYPE.getId().m_135815_();
    private final ResourceLocation recipeId;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final ItemData result;
    private final List<IngredientStack> ingredients = new ArrayList<IngredientStack>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private Ingredient reactant = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VIAL.get()});
    private int craftingTimeTicks = -1;
    private int craftingCostNutrients = -1;

    private BioBrewingRecipeBuilder(ResourceLocation recipeId, ItemData result) {
        this.recipeId = new ResourceLocation(recipeId.m_135827_(), RECIPE_SUB_FOLDER + "/" + recipeId.m_135815_());
        this.result = result;
    }

    public static BioBrewingRecipeBuilder create(ResourceLocation recipeId, ItemData result) {
        return new BioBrewingRecipeBuilder(recipeId, result);
    }

    public static BioBrewingRecipeBuilder create(String modId, String outputName, ItemData result) {
        ResourceLocation rl = new ResourceLocation(modId, outputName);
        return new BioBrewingRecipeBuilder(rl, result);
    }

    public static BioBrewingRecipeBuilder create(String outputName, ItemData result) {
        ResourceLocation rl = BiomancyMod.createRL(outputName);
        return new BioBrewingRecipeBuilder(rl, result);
    }

    public static BioBrewingRecipeBuilder create(ItemData result) {
        ResourceLocation rl = BiomancyMod.createRL(result.getItemPath());
        return new BioBrewingRecipeBuilder(rl, result);
    }

    public static BioBrewingRecipeBuilder create(ItemStack stack) {
        return BioBrewingRecipeBuilder.create(new ItemData(stack));
    }

    public static BioBrewingRecipeBuilder create(ItemLike item) {
        return BioBrewingRecipeBuilder.create(new ItemData(item));
    }

    public static BioBrewingRecipeBuilder create(ItemLike item, int count) {
        return BioBrewingRecipeBuilder.create(new ItemData(item, count));
    }

    public BioBrewingRecipeBuilder ifModLoaded(String modId) {
        return this.withCondition((ICondition)new ModLoadedCondition(modId));
    }

    public BioBrewingRecipeBuilder ifModMissing(String modId) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modId)));
    }

    public BioBrewingRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public BioBrewingRecipeBuilder setCraftingTime(int timeTicks) {
        if (timeTicks < 0) {
            throw new IllegalArgumentException("Invalid crafting time: " + timeTicks);
        }
        this.craftingTimeTicks = timeTicks;
        return this;
    }

    public BioBrewingRecipeBuilder setCraftingCost(int costNutrients) {
        if (costNutrients < 0) {
            throw new IllegalArgumentException("Invalid crafting cost: " + costNutrients);
        }
        this.craftingCostNutrients = costNutrients;
        return this;
    }

    public BioBrewingRecipeBuilder setReactant(ItemLike item) {
        return this.setReactant(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public BioBrewingRecipeBuilder setReactant(TagKey<Item> tag) {
        return this.setReactant(Ingredient.m_204132_(tag));
    }

    public BioBrewingRecipeBuilder setReactant(ItemStack stack) {
        return this.setReactant(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public BioBrewingRecipeBuilder setReactant(Ingredient ingredient) {
        this.reactant = ingredient;
        return this;
    }

    public BioBrewingRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public BioBrewingRecipeBuilder addIngredient(TagKey<Item> tag, int quantity) {
        return this.addIngredient(Ingredient.m_204132_(tag), quantity);
    }

    public BioBrewingRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public BioBrewingRecipeBuilder addIngredient(ItemStack stack) {
        return this.addIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), 1);
    }

    public BioBrewingRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public BioBrewingRecipeBuilder addIngredient(ItemLike item, int quantity) {
        this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), quantity);
        return this;
    }

    public BioBrewingRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        this.ingredients.add(new IngredientStack(ingredient, quantity));
        return this;
    }

    @Override
    public BioBrewingRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(name, criterionTrigger);
        return this;
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, @Nullable RecipeCategory category) {
        this.validateCriteria();
        if (this.craftingTimeTicks < 0) {
            this.craftingTimeTicks = 80;
        }
        if (this.craftingCostNutrients < 0) {
            this.craftingCostNutrients = RecipeCostUtil.getCost(2, this.craftingTimeTicks);
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        String folderName = RecipeBuilder.getRecipeFolderName(category, "biomancy");
        ResourceLocation advancementId = new ResourceLocation(this.recipeId.m_135827_(), "recipes/%s/%s".formatted(folderName, this.recipeId.m_135815_()));
        consumer.accept(new Result(this, advancementId));
    }

    private void validateCriteria() {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe %s because Criteria are empty.".formatted(this.recipeId));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<IngredientStack> ingredients;
        private final Ingredient reactant;
        private final ItemData result;
        private final int craftingTime;
        private final int craftingCost;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(BioBrewingRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = builder.recipeId;
            this.ingredients = builder.ingredients;
            this.reactant = builder.reactant;
            this.result = builder.result;
            this.craftingTime = builder.craftingTimeTicks;
            this.craftingCost = builder.craftingCostNutrients;
            this.conditions = builder.conditions;
            this.advancementBuilder = builder.advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonArray = new JsonArray();
            for (IngredientStack ingredient : this.ingredients) {
                jsonArray.add((JsonElement)ingredient.toJson());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            if (!this.reactant.m_43947_()) {
                json.add("reactant", this.reactant.m_43942_());
            }
            json.add("result", (JsonElement)this.result.toJson());
            json.addProperty("processingTime", (Number)this.craftingTime);
            json.addProperty("nutrientsCost", (Number)this.craftingCost);
            if (!this.conditions.isEmpty()) {
                JsonArray array = new JsonArray();
                this.conditions.forEach(c -> array.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)array);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.BIO_BREWING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            if (this.conditions.isEmpty()) {
                return this.advancementBuilder.m_138400_();
            }
            ConditionalAdvancement.Builder conditionalBuilder = ConditionalAdvancement.builder();
            this.conditions.forEach(arg_0 -> ((ConditionalAdvancement.Builder)conditionalBuilder).addCondition(arg_0));
            conditionalBuilder.addAdvancement(this.advancementBuilder);
            return conditionalBuilder.write();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

