/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PlayerHeadRecipe
extends CustomRecipe {
    public PlayerHeadRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level level) {
        boolean hasPlayerHead = false;
        boolean hasPlayerUUID = false;
        boolean hasExoticDust = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == Items.f_42680_) {
                if (hasPlayerHead) {
                    return false;
                }
                hasPlayerHead = true;
                continue;
            }
            if (item == ModItems.EXOTIC_DUST.get()) {
                if (hasExoticDust) {
                    return false;
                }
                hasExoticDust = true;
                continue;
            }
            if (item instanceof EssenceItem) {
                EssenceItem essenceItem = (EssenceItem)item;
                if (hasPlayerUUID) {
                    return false;
                }
                if (!essenceItem.getEntityType(stack).filter(entityType -> entityType == EntityType.f_20532_).isPresent()) continue;
                hasPlayerUUID = essenceItem.getEntityUUID(stack).isPresent();
                continue;
            }
            return false;
        }
        return hasPlayerHead && hasPlayerUUID && hasExoticDust;
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess registryAccess) {
        UUID uuid = null;
        boolean hasPlayerHead = false;
        boolean hasExoticDust = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == Items.f_42680_) {
                if (hasPlayerHead) {
                    return ItemStack.f_41583_;
                }
                hasPlayerHead = true;
                continue;
            }
            if (item == ModItems.EXOTIC_DUST.get()) {
                if (hasExoticDust) {
                    return ItemStack.f_41583_;
                }
                hasExoticDust = true;
                continue;
            }
            if (item instanceof EssenceItem) {
                EssenceItem essenceItem = (EssenceItem)item;
                if (uuid != null) {
                    return ItemStack.f_41583_;
                }
                if (!essenceItem.getEntityType(stack).filter(entityType -> entityType == EntityType.f_20532_).isPresent()) continue;
                uuid = essenceItem.getEntityUUID(stack).orElse(null);
                continue;
            }
            return ItemStack.f_41583_;
        }
        return hasPlayerHead && uuid != null && hasExoticDust ? this.createPlayerHeadFrom(uuid) : ItemStack.f_41583_;
    }

    private ItemStack createPlayerHeadFrom(UUID uuid) {
        GameProfile gameProfile = new GameProfile(uuid, null);
        ItemStack stack = Items.f_42680_.m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameProfile));
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.PLAYER_HEAD_SERIALIZER.get();
    }
}

