/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.render.block.tongue;

import com.github.elenterius.biomancy.block.tongue.TongueBlockEntity;
import com.github.elenterius.biomancy.client.render.block.CustomGeoBlockRenderer;
import com.github.elenterius.biomancy.client.render.block.tongue.TongueModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;

public class TongueRenderer
extends CustomGeoBlockRenderer<TongueBlockEntity> {
    private final RandomSource random = RandomSource.m_216327_();
    private final ItemRenderer itemRenderer;
    private ItemStack heldItemStack = ItemStack.f_41583_;

    public TongueRenderer(BlockEntityRendererProvider.Context context) {
        super(new TongueModel());
        this.itemRenderer = context.m_234447_();
    }

    public void preRender(PoseStack poseStack, TongueBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.heldItemStack = animatable.getHeldItem();
        super.preRender(poseStack, (BlockEntity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack poseStack, TongueBlockEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("_item") && !this.heldItemStack.m_41619_()) {
            int itemCount = Math.min(this.heldItemStack.m_41613_(), 3);
            int seed = Item.m_41393_((Item)this.heldItemStack.m_41720_()) + this.heldItemStack.m_41773_();
            this.renderItems(poseStack, bufferSource, packedLight, packedOverlay, itemCount, seed);
        }
        super.renderRecursively(poseStack, (BlockEntity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void renderItems(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, int itemCount, int seed) {
        this.random.m_188584_((long)seed);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.385, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        BakedModel bakedmodel = this.itemRenderer.m_174264_(this.heldItemStack, null, null, seed);
        boolean isGUI3d = bakedmodel.m_7539_();
        if (isGUI3d) {
            poseStack.m_85837_(0.0, 0.0, 0.1);
        }
        for (int i = 0; i < itemCount; ++i) {
            poseStack.m_85836_();
            if (i > 0) {
                float x = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                float y = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                if (isGUI3d) {
                    poseStack.m_252880_(x, y, (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f);
                } else {
                    poseStack.m_252880_(x * 0.5f, y * 0.5f, 0.0f);
                }
            }
            this.itemRenderer.m_269128_(this.heldItemStack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, null, 0);
            poseStack.m_85849_();
            if (isGUI3d) continue;
            poseStack.m_252880_(0.0f, 0.0f, 0.025f);
        }
        poseStack.m_85849_();
    }
}

