/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.render.block.cradle;

import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlockEntity;
import com.github.elenterius.biomancy.client.render.block.CustomGeoBlockRenderer;
import com.github.elenterius.biomancy.client.render.block.cradle.PrimordialCradleModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;

public class PrimordialCradleRenderer
extends CustomGeoBlockRenderer<PrimordialCradleBlockEntity> {
    private final Vector4f vertexPosition = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    private float lifeEnergyPct;
    private boolean isSpecialCube = false;
    private MultiBufferSource mbs = null;

    public PrimordialCradleRenderer(BlockEntityRendererProvider.Context context) {
        super(new PrimordialCradleModel());
    }

    public void preRender(PoseStack poseStack, PrimordialCradleBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        AnimationProcessor processor = this.getGeoModel().getAnimationProcessor();
        CoreGeoBone boneFillLevel = processor.getBone("_fill_level");
        CoreGeoBone boneToppings = processor.getBone("_toppings");
        boneFillLevel.setHidden(true);
        boneToppings.setHidden(true);
        float biomassPct = animatable.getBiomassPct();
        if (biomassPct > 0.0f) {
            boneFillLevel.setHidden(false);
            boneFillLevel.setPosY((float)Mth.m_14143_((float)(biomassPct * 8.0f)) + 2.0f);
            if (animatable.hasModifiers()) {
                boneToppings.setHidden(false);
            }
        }
        this.lifeEnergyPct = Math.min(animatable.getLifeEnergyPct(), 1.0f);
        this.mbs = bufferSource;
        super.preRender(poseStack, (BlockEntity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderCubesOfBone(PoseStack stack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("_eye_overlay")) {
            if (this.lifeEnergyPct > 0.0f) {
                this.isSpecialCube = true;
                if (!bone.isHidden()) {
                    for (GeoCube cube : bone.getCubes()) {
                        stack.m_85836_();
                        this.renderCube(stack, cube, this.mbs.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation((GeoAnimatable)((PrimordialCradleBlockEntity)this.animatable)))), 0xF000F0, OverlayTexture.f_118083_, red, green, blue, alpha);
                        stack.m_85849_();
                    }
                }
                this.isSpecialCube = false;
            }
        } else {
            super.renderCubesOfBone(stack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public void createVerticesOfQuad(GeoQuad quad, Matrix4f matrix4f, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        GeoVertex[] vertices = quad.vertices();
        if (this.isSpecialCube && quad.direction() == Direction.NORTH) {
            float steps = (vertices[0].position().y() - vertices[2].position().y()) * 16.0f;
            float delta = ((float)Mth.m_14143_((float)(this.lifeEnergyPct * (steps - 1.0f))) + 1.0f) / steps;
            float textureV = Mth.m_14179_((float)delta, (float)vertices[2].texV(), (float)vertices[0].texV());
            float positionY = Mth.m_14179_((float)delta, (float)vertices[2].position().y(), (float)vertices[0].position().y());
            GeoVertex topLeft = vertices[0];
            GeoVertex topRight = vertices[1];
            for (GeoVertex vertex : vertices) {
                boolean isTopVertex;
                boolean bl = isTopVertex = vertex == topLeft || vertex == topRight;
                if (isTopVertex) {
                    this.createVertex(matrix4f, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha, vertex, textureV, positionY);
                    continue;
                }
                this.createVertex(matrix4f, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha, vertex);
            }
        } else {
            for (GeoVertex vertex : vertices) {
                this.createVertex(matrix4f, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha, vertex);
            }
        }
    }

    private void createVertex(Matrix4f matrix4f, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, GeoVertex geoVertex) {
        this.vertexPosition.set(geoVertex.position().x(), geoVertex.position().y(), geoVertex.position().z(), 1.0f);
        matrix4f.transform(this.vertexPosition);
        buffer.m_5954_(this.vertexPosition.x(), this.vertexPosition.y(), this.vertexPosition.z(), red, green, blue, alpha, geoVertex.texU(), geoVertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
    }

    private void createVertex(Matrix4f matrix4f, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, GeoVertex geoVertex, float v, float y) {
        this.vertexPosition.set(geoVertex.position().x(), y, geoVertex.position().z(), 1.0f);
        matrix4f.transform(this.vertexPosition);
        buffer.m_5954_(this.vertexPosition.x(), this.vertexPosition.y(), this.vertexPosition.z(), red, green, blue, alpha, geoVertex.texU(), v, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
    }
}

