/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.particle;

import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.statuseffect.BleedEffect;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BloodDripParticle
extends TextureSheetParticle {
    protected BloodDripParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.setColorRGB(((BleedEffect)ModMobEffects.BLEED.get()).m_19484_());
    }

    public void setColorRGB(int color) {
        this.f_107227_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        this.f_107228_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        this.f_107229_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
    }

    public void setColorARGB(int color) {
        this.f_107227_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        this.f_107228_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        this.f_107229_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        this.f_107230_ = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
            return;
        }
        if (this.f_107220_) {
            return;
        }
        this.f_107216_ -= (double)this.f_107226_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.postMoveUpdate();
        if (!this.f_107220_) {
            this.f_107215_ *= (double)0.98f;
            this.f_107216_ *= (double)0.98f;
            this.f_107217_ *= (double)0.98f;
        }
    }

    protected abstract void postMoveUpdate();

    public static class LandingBloodFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LandingBloodFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LandingBloodParticle particle = new LandingBloodParticle(level, x, y, z);
            ((BloodDripParticle)particle).f_107225_ = (int)(128.0 / ((double)level.m_213780_().m_188501_() * 0.8 + 0.2));
            particle.m_108335_(this.sprite);
            return particle;
        }
    }

    public static class FallingBloodFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public FallingBloodFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingBloodParticle particle = new FallingBloodParticle(level, x, y, z, (ParticleOptions)ModParticleTypes.LANDING_BLOOD.get());
            ((BloodDripParticle)particle).f_107225_ = (int)(64.0f / (level.m_213780_().m_188501_() * 0.8f + 0.2f));
            particle.m_172260_(xSpeed, ySpeed, zSpeed);
            particle.m_108335_(this.sprite);
            return particle;
        }
    }

    static class LandingBloodParticle
    extends BloodDripParticle {
        protected LandingBloodParticle(ClientLevel level, double x, double y, double z) {
            super(level, x, y, z);
            this.f_107226_ = 0.06f;
        }

        @Override
        protected void postMoveUpdate() {
        }
    }

    static class FallingBloodParticle
    extends BloodDripParticle {
        protected final ParticleOptions landingParticle;

        protected FallingBloodParticle(ClientLevel level, double x, double y, double z, ParticleOptions landingParticle) {
            super(level, x, y, z);
            this.landingParticle = landingParticle;
            this.f_107226_ = 0.01f;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landingParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                float volume = Mth.m_216283_((RandomSource)this.f_107223_, (float)0.3f, (float)1.0f);
                this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, SoundEvents.f_11694_, SoundSource.BLOCKS, volume, 1.0f, false);
            }
        }
    }
}

