/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.serum.Serum;
import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.client.util.GuiRenderUtil;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import com.github.elenterius.biomancy.network.ModNetworkHandler;
import com.github.elenterius.biomancy.styles.ColorStyles;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;

public class InjectorScreen
extends Screen {
    public static final ResourceLocation ICONS = BiomancyMod.createRL("textures/gui/wheel_icons.png");
    public static final int CANCEL_ID = -1;
    public static final int CLEAR_ID = -2;
    static final float DIAGONAL_OF_ITEM = Mth.f_13994_ * 32.0f;
    static final int DURATION = 10;
    private Object2IntMap<ItemStack> cachedStacks;
    private int ticks;
    private int refreshCacheTicks;
    private final InteractionHand itemHoldingHand;

    public InjectorScreen(InteractionHand hand) {
        super((Component)ComponentUtil.translatable("biomancy.injector.wheel_menu"));
        this.itemHoldingHand = hand;
    }

    protected void m_7856_() {
        this.ticks = 0;
        this.refreshCacheTicks = 0;
        this.cachedStacks = null;
        double x = (double)this.f_96541_.m_91268_().m_85443_() / 2.0;
        double y = (double)this.f_96541_.m_91268_().m_85444_() / 2.0 - 16.0;
        InputConstants.m_84833_((long)this.f_96541_.m_91268_().m_85439_(), (int)212993, (double)x, (double)y);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.cachedStacks = null;
        super.m_7379_();
    }

    public void m_86600_() {
        if (this.ticks < 0 || this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            this.m_7379_();
            return;
        }
        ItemStack stack = this.f_96541_.f_91074_.m_21120_(this.itemHoldingHand);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof InjectorItem)) {
            this.m_7379_();
            return;
        }
        if (++this.refreshCacheTicks % 8 == 0 || this.cachedStacks == null || this.cachedStacks.isEmpty()) {
            this.cachedStacks = this.findSerumStacks(this.f_96541_.f_91074_);
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.ticks = 10;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.cachedStacks == null || this.cachedStacks.isEmpty()) {
            this.m_7379_();
            return false;
        }
        if (this.ticks < 9) {
            return false;
        }
        ObjectSet stackEntries = this.cachedStacks.object2IntEntrySet();
        int segments = stackEntries.size();
        float angleIncrement = (float)Math.PI * 2 / (float)segments;
        float x = (float)this.f_96543_ / 2.0f;
        float y = (float)this.f_96544_ / 2.0f;
        float upperBound = (float)segments * angleIncrement - 1.5707964f + angleIncrement / 2.0f;
        float lowerBound = -1.5707964f - angleIncrement / 2.0f;
        float mouseAngle = (float)Mth.m_14136_((double)(mouseY - (double)y), (double)(mouseX - (double)x));
        if (mouseAngle > upperBound) {
            mouseAngle -= (float)Math.PI * 2;
        }
        if (mouseAngle < lowerBound) {
            mouseAngle += (float)Math.PI * 2;
        }
        int i = 0;
        for (Object2IntMap.Entry entry : stackEntries) {
            boolean isMouseInSection;
            float currentAngle = (float)i * angleIncrement - 1.5707964f;
            boolean bl = isMouseInSection = mouseAngle >= currentAngle - angleIncrement / 2.0f && mouseAngle < currentAngle + angleIncrement / 2.0f;
            if (isMouseInSection) {
                int idx = this.cachedStacks.getOrDefault(entry.getKey(), -1);
                if (idx == -1) break;
                ModNetworkHandler.sendKeyBindPressToServer(this.itemHoldingHand, (byte)idx);
                break;
            }
            ++i;
        }
        this.m_7379_();
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.ticks < 0) {
            return;
        }
        float time = (float)this.ticks + partialTick;
        if (time > 10.0f) {
            time = 10.0f;
        }
        this.renderWheel(guiGraphics, mouseX, mouseY, time / 10.0f);
    }

    private void renderWheel(GuiGraphics guiGraphics, int mouseX, int mouseY, float pct) {
        MutableComponent text;
        if (this.cachedStacks == null || this.cachedStacks.isEmpty()) {
            return;
        }
        int blitOffset = 0;
        ObjectSet stackEntries = this.cachedStacks.object2IntEntrySet();
        int segments = stackEntries.size();
        float angleIncrement = (float)Math.PI * 2 / (float)segments;
        float baseRadius = DIAGONAL_OF_ITEM / angleIncrement;
        float x = (float)this.f_96543_ / 2.0f;
        float y = (float)this.f_96544_ / 2.0f;
        int radius = Mth.m_14143_((float)(baseRadius * pct));
        float upperBound = (float)segments * angleIncrement - 1.5707964f + angleIncrement / 2.0f;
        float lowerBound = -1.5707964f - angleIncrement / 2.0f;
        float mouseAngle = (float)Mth.m_14136_((double)((float)mouseY - y), (double)((float)mouseX - x));
        if (mouseAngle > upperBound) {
            mouseAngle -= (float)Math.PI * 2;
        }
        if (mouseAngle < lowerBound) {
            mouseAngle += (float)Math.PI * 2;
        }
        ItemStack stack = ItemStack.f_41583_;
        float textAngle = 0.0f;
        int i = 0;
        for (Object2IntMap.Entry entry : stackEntries) {
            float currentAngle = (float)i * angleIncrement - 1.5707964f;
            boolean isMouseInSection = (float)radius > baseRadius - 1.0f && mouseAngle >= currentAngle - angleIncrement / 2.0f && mouseAngle < currentAngle + angleIncrement / 2.0f;
            int color = isMouseInSection ? ColorStyles.GENERIC_TOOLTIP.borderStartColor() & 0xFAFFFFFF : ColorStyles.GENERIC_TOOLTIP.backgroundColor() & 0xE0FFFFFF;
            this.drawSegment(guiGraphics, x, y, radius, currentAngle - angleIncrement / 2.0f, currentAngle, color, blitOffset);
            this.drawSegment(guiGraphics, x, y, radius, currentAngle, currentAngle + angleIncrement / 2.0f, color, blitOffset);
            float v = x + (float)radius * Mth.m_14089_((float)currentAngle);
            float w = y + (float)radius * Mth.m_14031_((float)currentAngle);
            ItemStack currentStack = (ItemStack)entry.getKey();
            if (currentStack.m_41619_()) {
                guiGraphics.m_280163_(ICONS, Mth.m_14143_((float)(v - 8.0f)), Mth.m_14143_((float)(w - 8.0f)), 0.0f, 0.0f, 16, 16, 32, 16);
            } else if (currentStack.m_41720_() == Items.f_42127_) {
                guiGraphics.m_280163_(ICONS, Mth.m_14143_((float)(v - 8.0f)), Mth.m_14143_((float)(w - 8.0f)), 16.0f, 0.0f, 16, 16, 32, 16);
            } else {
                guiGraphics.m_280203_(currentStack, Mth.m_14143_((float)(v - 8.0f)), Mth.m_14143_((float)(w - 8.0f)));
            }
            if (isMouseInSection) {
                stack = currentStack;
                textAngle = currentAngle;
            }
            ++i;
        }
        if ((float)radius <= baseRadius - 1.0f) {
            return;
        }
        if (stack.m_41619_()) {
            text = ComponentUtil.literal("Clear").m_130948_(TextStyles.ERROR);
        } else if (stack.m_41720_() == Items.f_42127_) {
            text = ComponentUtil.literal("Cancel");
        } else {
            text = ComponentUtil.mutable().m_7220_(stack.m_41786_());
            if (stack.m_41788_()) {
                text.m_130940_(ChatFormatting.ITALIC);
            }
        }
        int textRadius = radius + 16 + 8 + 2;
        float xt = x + (float)textRadius * Mth.m_14089_((float)textAngle);
        float yt = y + (float)textRadius * Mth.m_14031_((float)textAngle);
        int lineWidth = this.f_96547_.m_92852_((FormattedText)text);
        float offsetAngle = textAngle + 1.5707964f;
        if (offsetAngle == 0.0f || offsetAngle == (float)Math.PI) {
            xt -= (float)lineWidth / 2.0f;
        }
        if (offsetAngle > (float)Math.PI) {
            xt -= (float)lineWidth;
        }
        this.drawItemLabel(guiGraphics, xt, yt, blitOffset, (Component)text, lineWidth);
    }

    private void drawItemLabel(GuiGraphics guiGraphics, float x, float y, int zDepth, Component text, int lineWidth) {
        guiGraphics.m_280168_().m_85836_();
        int minX = (int)x;
        Objects.requireNonNull(this.f_96547_);
        int minY = (int)(y - 9.0f / 2.0f);
        int maxX = minX + lineWidth;
        Objects.requireNonNull(this.f_96547_);
        int maxY = (int)(y + 9.0f / 2.0f);
        GuiRenderUtil.fill(guiGraphics, (float)minX - 3.0f, (float)minY - 3.0f, (float)maxX + 2.0f, (float)maxY + 1.5f, zDepth, ColorStyles.GENERIC_TOOLTIP.backgroundColor() & 0xE0FFFFFF);
        guiGraphics.m_280614_(this.f_96547_, text, minX, minY, -1, true);
        guiGraphics.m_280168_().m_85849_();
    }

    public void drawSegment(GuiGraphics guiGraphics, float x, float y, float radius, float startAngle, float endAngle, int argbColor, int blitOffset) {
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float innerRadius = Math.max(radius - 16.0f, 0.0f);
        bufferBuilder.m_252986_(matrix4f, x + innerRadius * Mth.m_14089_((float)startAngle), y + innerRadius * Mth.m_14031_((float)startAngle), (float)blitOffset).m_193479_(argbColor).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x + innerRadius * Mth.m_14089_((float)endAngle), y + innerRadius * Mth.m_14031_((float)endAngle), (float)blitOffset).m_193479_(argbColor).m_5752_();
        float outerRadius = radius + 16.0f;
        bufferBuilder.m_252986_(matrix4f, x + outerRadius * Mth.m_14089_((float)endAngle), y + outerRadius * Mth.m_14031_((float)endAngle), (float)blitOffset).m_193479_(argbColor).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x + outerRadius * Mth.m_14089_((float)startAngle), y + outerRadius * Mth.m_14031_((float)startAngle), (float)blitOffset).m_193479_(argbColor).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private Object2IntMap<ItemStack> findSerumStacks(LocalPlayer player) {
        Object2IntArrayMap foundStacks = new Object2IntArrayMap();
        Object2IntArrayMap foundSerums = new Object2IntArrayMap();
        foundStacks.put((Object)new ItemStack((ItemLike)Items.f_42127_), -1);
        Inventory inventory = player.m_150109_();
        int slots = inventory.m_6643_();
        for (int idx = 0; idx < slots; ++idx) {
            SerumContainer vial;
            Serum serum;
            ItemStack stack = inventory.m_8020_(idx);
            Item item = stack.m_41720_();
            if (!(item instanceof SerumContainer) || (serum = (vial = (SerumContainer)item).getSerum()).isEmpty()) continue;
            if (!foundSerums.containsKey((Object)serum)) {
                foundStacks.put((Object)stack, idx);
            }
            foundSerums.mergeInt((Object)serum, stack.m_41613_(), Integer::sum);
        }
        foundStacks.put((Object)ItemStack.f_41583_, -2);
        return foundStacks;
    }
}

