/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.client.gui.tooltip.ScreenNutrientFuelConsumer;
import com.github.elenterius.biomancy.client.gui.tooltip.ScreenTooltipStyleProvider;
import com.github.elenterius.biomancy.client.util.GuiRenderUtil;
import com.github.elenterius.biomancy.client.util.GuiUtil;
import com.github.elenterius.biomancy.menu.BioLabMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BioLabScreen
extends AbstractContainerScreen<BioLabMenu>
implements ScreenTooltipStyleProvider,
ScreenNutrientFuelConsumer {
    private static final ResourceLocation BACKGROUND_TEXTURE = BiomancyMod.createRL("textures/gui/menu_bio_lab.png");

    public BioLabScreen(BioLabMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97727_ = 219;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = this.f_97735_ + 130;
        int y = this.f_97736_ + 34;
        if (GuiUtil.isInRect(x, y, 8, 10, mouseX, mouseY)) {
            this.f_96541_.f_91072_.m_105208_(((BioLabMenu)this.f_97732_).f_38840_, 0);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.drawProgressBar(guiGraphics, ((BioLabMenu)this.f_97732_).getCraftingProgressNormalized());
        this.drawFuelBar(guiGraphics, ((BioLabMenu)this.f_97732_).getFuelAmountNormalized());
        ((BioLabMenu)this.f_97732_).renderFilters(guiGraphics, this.f_96541_, this.f_97735_, this.f_97736_);
        this.drawLock(guiGraphics, ((BioLabMenu)this.f_97732_).isFilterLocked());
    }

    private void drawProgressBar(GuiGraphics guiGraphics, float craftingPct) {
        int vHeight = (int)(craftingPct * 20.0f) + (craftingPct > 0.0f ? 1 : 0);
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 68, this.f_97736_ + 78, 176, 0, 40, vHeight);
    }

    private void drawFuelBar(GuiGraphics guiGraphics, float fuelPct) {
        int vHeight = (int)(fuelPct * 36.0f) + (fuelPct > 0.0f ? 1 : 0);
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 36, this.f_97736_ + 48 + 36 - vHeight, 178, 58 - vHeight, 5, vHeight);
        int cost = ((BioLabMenu)this.f_97732_).getFuelCost();
        if (cost <= ((BioLabMenu)this.f_97732_).getFuelAmount()) {
            return;
        }
        int x = this.f_97735_ + 36;
        int y = this.f_97736_ + 48 + 36 - ((int)((float)cost / (float)((BioLabMenu)this.f_97732_).getMaxFuelAmount() * 36.0f) + 1);
        guiGraphics.m_280509_(x - 3, y, x + 5 + 3, y + 1, 0x30FF0000);
        guiGraphics.m_280509_(x + 5 + 3, y, x + 5 + 3 + 1, y + 1, -65536);
        guiGraphics.m_280509_(x + 5 + 3 + 1, y - 1, x + 5 + 3 + 2, y + 2, -65536);
    }

    private void drawLock(GuiGraphics guiGraphics, boolean isLocked) {
        int offset = isLocked ? 0 : 8;
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 130, this.f_97736_ + 34, 178 + offset, 60, 8, 10);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((BioLabMenu)this.f_97732_).m_142621_().m_41619_() && GuiUtil.isInRect(this.f_97735_ + 36, this.f_97736_ + 48, 5, 36, mouseX, mouseY)) {
            this.drawFuelTooltip(guiGraphics, mouseX, mouseY);
            return;
        }
        super.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void drawFuelTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int maxFuel = ((BioLabMenu)this.f_97732_).getMaxFuelAmount();
        int fuelAmount = ((BioLabMenu)this.f_97732_).getFuelAmount();
        int totalFuelCost = ((BioLabMenu)this.f_97732_).getFuelCost();
        GuiRenderUtil.drawFuelTooltip(this.f_96547_, guiGraphics, mouseX, mouseY, maxFuel, fuelAmount, totalFuelCost);
    }
}

