/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui;

import com.github.elenterius.biomancy.BiomancyConfig;
import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.BioForgingRecipe;
import com.github.elenterius.biomancy.init.ModBioForgeTabs;
import com.github.elenterius.biomancy.init.ModRecipeBookTypes;
import com.github.elenterius.biomancy.init.client.ModRecipeBookCategories;
import com.github.elenterius.biomancy.integration.BioForgeCompat;
import com.github.elenterius.biomancy.menu.BioForgeMenu;
import com.github.elenterius.biomancy.menu.BioForgeTab;
import com.github.elenterius.biomancy.mixin.accessor.RecipeCollectionAccessor;
import com.github.elenterius.biomancy.network.ModNetworkHandler;
import com.github.elenterius.biomancy.util.ItemStackCounter;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

class BioForgeScreenController {
    public static final int ROWS = 6;
    public static final int COLS = 4;
    public static final int GRID_SIZE = 24;
    private static final Comparator<BioForgeTab> CATEGORY_COMPARATOR = (a, b) -> {
        if (a.sortPriority() == b.sortPriority()) {
            return a.enumId().compareTo(b.enumId());
        }
        return b.sortPriority() - a.sortPriority();
    };
    private static RecipeSelection recipeSelection = RecipeSelection.EMPTY;
    private final ItemStackCounter itemCounter;
    private final List<BioForgeTab> tabs;
    private final Minecraft minecraft;
    private final BioForgeMenu menu;
    private int maxPages = 0;
    private int activeTab = 0;
    private int startIndex = 0;
    private int playerInvChanges;
    private String currentSearchString = "";
    private List<RecipeCollection> shownRecipes = List.of();
    private int crossoverGridIndex = 0;

    public BioForgeScreenController(Minecraft minecraft, BioForgeMenu menu) {
        this.minecraft = minecraft;
        this.menu = menu;
        this.tabs = ModBioForgeTabs.REGISTRY.get().getValues().stream().sorted(CATEGORY_COMPARATOR).toList();
        this.playerInvChanges = this.getPlayer().m_150109_().m_36072_();
        this.itemCounter = new ItemStackCounter();
        this.itemCounter.accountStacks((NonNullList<ItemStack>)this.getPlayer().m_150109_().f_35974_);
        if (recipeSelection != RecipeSelection.EMPTY && menu.getSelectedRecipe() == null && BioForgeScreenController.recipeSelection.recipe != null) {
            ModNetworkHandler.sendBioForgeRecipeToServer(menu.f_38840_, BioForgeScreenController.recipeSelection.recipe);
        }
        this.updateAndSearchRecipes();
    }

    private ClientLevel getLevel() {
        return Objects.requireNonNull(this.minecraft.f_91073_);
    }

    private LocalPlayer getPlayer() {
        return Objects.requireNonNull(this.minecraft.f_91074_);
    }

    public void resetPagination() {
        this.startIndex = 0;
    }

    public int getCurrentPage() {
        return this.startIndex / 24 + 1;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public void goToNextPage() {
        if (this.hasNextPage()) {
            this.startIndex += 24;
        }
    }

    public boolean hasNextPage() {
        return this.getCurrentPage() < this.maxPages;
    }

    public boolean hasPrevPage() {
        return this.getCurrentPage() > 1;
    }

    public void goToPrevPage() {
        if (this.hasPrevPage()) {
            this.startIndex -= 24;
        }
    }

    public boolean hasRecipesOnPage() {
        return !this.shownRecipes.isEmpty();
    }

    public List<BioForgingRecipe> getOrderedRecipes(RecipeCollection recipeCollection) {
        List list = recipeCollection.m_100513_(true);
        if (!this.getPlayer().m_108631_().m_12704_(ModRecipeBookTypes.BIO_FORGE)) {
            list.addAll(recipeCollection.m_100513_(false));
        }
        return list.stream().map(BioForgingRecipe.class::cast).toList();
    }

    private BioForgingRecipe getRecipe(int index) {
        if (index >= this.shownRecipes.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.getOrderedRecipes(this.shownRecipes.get(index)).get(0);
    }

    public RecipeCollection getRecipeCollectionByGrid(int gridIndex) {
        if (gridIndex >= 24) {
            throw new IndexOutOfBoundsException(gridIndex);
        }
        return this.shownRecipes.get(this.startIndex + gridIndex);
    }

    public BioForgingRecipe getRecipeByGrid(int gridIndex) {
        if (gridIndex >= 24) {
            throw new IndexOutOfBoundsException(gridIndex);
        }
        return this.getRecipe(this.startIndex + gridIndex);
    }

    public int getTotalItemCountInPlayerInv(ItemStack stack) {
        return this.itemCounter.getCount(stack);
    }

    public boolean hasSufficientIngredientCount(IngredientStack ingredientStack) {
        return ingredientStack.hasSufficientCount(this.itemCounter);
    }

    public int getMaxRecipesOnGrid() {
        return Math.min(24, this.shownRecipes.size() - this.startIndex);
    }

    public boolean isSelectedRecipeVisible() {
        int maxIndex = this.startIndex + 24;
        if (BioForgeScreenController.recipeSelection.tab == this.activeTab) {
            return BioForgeScreenController.recipeSelection.index >= this.startIndex && BioForgeScreenController.recipeSelection.index < maxIndex && this.getGridIndexOfSelectedRecipe() < this.getMaxRecipesOnGrid();
        }
        if (BioForgeScreenController.recipeSelection.recipe != null && (this.activeTab == 0 || this.getCurrentCategory() == BioForgeScreenController.recipeSelection.recipe.getTab())) {
            int maxRecipes = this.getMaxRecipesOnGrid();
            for (int gridIndex = 0; gridIndex < maxRecipes; ++gridIndex) {
                if (!this.getRecipe(this.startIndex + gridIndex).isRecipeEqual(BioForgeScreenController.recipeSelection.recipe)) continue;
                this.crossoverGridIndex = this.startIndex + gridIndex;
                return true;
            }
        }
        this.crossoverGridIndex = 0;
        return false;
    }

    public int getGridIndexOfSelectedRecipe() {
        if (BioForgeScreenController.recipeSelection.tab == this.activeTab) {
            return BioForgeScreenController.recipeSelection.index - this.startIndex;
        }
        if (BioForgeScreenController.recipeSelection.recipe != null && (this.activeTab == 0 || this.getCurrentCategory() == BioForgeScreenController.recipeSelection.recipe.getTab())) {
            return this.crossoverGridIndex - this.startIndex;
        }
        return 0;
    }

    public final boolean hasSelectedRecipe() {
        return this.getSelectedRecipe() != null;
    }

    @Nullable
    public BioForgingRecipe getSelectedRecipe() {
        return BioForgeScreenController.recipeSelection.recipe;
    }

    void setSelectedRecipe(int gridIndex) {
        if (gridIndex < 0) {
            recipeSelection = RecipeSelection.EMPTY;
            return;
        }
        int recipeIndex = this.startIndex + gridIndex;
        BioForgingRecipe recipe = this.getRecipe(recipeIndex);
        recipeSelection = new RecipeSelection(recipe, this.activeTab, recipeIndex);
        ModNetworkHandler.sendBioForgeRecipeToServer(this.menu.f_38840_, recipe);
    }

    public BioForgeTab getCurrentCategory() {
        return this.tabs.get(this.activeTab);
    }

    public int getTabIndex(BioForgeTab category) {
        for (int tabIndex = 0; tabIndex < this.tabs.size(); ++tabIndex) {
            if (this.tabs.get(tabIndex) != category) continue;
            return tabIndex;
        }
        return 0;
    }

    public void tick() {
        this.trackPlayerInvChanges();
    }

    public void trackPlayerInvChanges() {
        if (this.playerInvChanges != this.getPlayer().m_150109_().m_36072_()) {
            this.countPlayerInvItems();
            this.playerInvChanges = this.getPlayer().m_150109_().m_36072_();
        }
    }

    private void countPlayerInvItems() {
        this.itemCounter.clear();
        this.itemCounter.accountStacks((NonNullList<ItemStack>)this.getPlayer().m_150109_().f_35974_);
        this.updateAndSearchRecipes();
    }

    public void updateSearchString(String searchString) {
        if ((searchString = searchString.toLowerCase(Locale.ROOT)).equals(this.currentSearchString)) {
            return;
        }
        this.updateAndSearchRecipes();
        this.currentSearchString = searchString;
    }

    private static void canCraftRecipe(RecipeCollection recipeCollection, ItemStackCounter itemCounter, RecipeBook book, boolean isCreativePlayer) {
        RecipeCollectionAccessor accessor = (RecipeCollectionAccessor)recipeCollection;
        Set<Recipe<?>> fitDimensions = accessor.biomancy$getFitDimensions();
        Set<Recipe<?>> craftable = accessor.biomancy$getCraftable();
        for (Recipe recipe : recipeCollection.m_100516_()) {
            boolean canCraftRecipe;
            boolean isRecipeKnown = isCreativePlayer || book.m_12709_(recipe);
            boolean bl = canCraftRecipe = recipe.m_8004_(0, 0) && isRecipeKnown;
            if (canCraftRecipe) {
                fitDimensions.add(recipe);
            } else {
                fitDimensions.remove(recipe);
            }
            if (recipe instanceof BioForgingRecipe) {
                BioForgingRecipe bioForgingRecipe = (BioForgingRecipe)recipe;
                if (canCraftRecipe && bioForgingRecipe.isCraftable(itemCounter)) {
                    craftable.add(recipe);
                    continue;
                }
                craftable.remove(recipe);
                continue;
            }
            craftable.remove(recipe);
        }
    }

    private void updateAndSearchRecipes() {
        LocalPlayer player = this.getPlayer();
        boolean isCreativePlayer = player.m_7500_() || (Boolean)BiomancyConfig.SERVER.doBioForgeRecipeProgression.get() == false || BioForgeCompat.isRecipeCollectionOverwriteEnabled();
        ClientRecipeBook recipeBook = player.m_108631_();
        List recipesForCategory = recipeBook.m_90623_(ModRecipeBookCategories.getRecipeBookCategories(this.tabs.get(this.activeTab)));
        recipesForCategory.forEach(recipeCollection -> BioForgeScreenController.canCraftRecipe(recipeCollection, this.itemCounter, (RecipeBook)recipeBook, isCreativePlayer));
        ArrayList recipes = Lists.newArrayList((Iterable)recipesForCategory);
        if (!isCreativePlayer) {
            recipes.removeIf(recipeCollection -> !recipeCollection.m_100498_());
        }
        recipes.removeIf(recipeCollection -> !recipeCollection.m_100515_());
        if (!this.currentSearchString.isEmpty()) {
            ObjectLinkedOpenHashSet searchResult = new ObjectLinkedOpenHashSet((Collection)this.minecraft.m_231372_(SearchRegistry.f_119943_).m_6293_(this.currentSearchString));
            recipes.removeIf(arg_0 -> BioForgeScreenController.lambda$updateAndSearchRecipes$4((ObjectSet)searchResult, arg_0));
        }
        if (recipeBook.m_12704_(ModRecipeBookTypes.BIO_FORGE)) {
            recipes.removeIf(recipeCollection -> !recipeCollection.m_100512_());
        }
        this.setShownRecipes(recipes);
    }

    private void setShownRecipes(List<RecipeCollection> recipes) {
        this.shownRecipes = recipes;
        this.maxPages = Mth.m_14167_((float)((float)recipes.size() / 24.0f));
        if (this.maxPages <= this.getCurrentPage()) {
            this.resetPagination();
        }
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public BioForgeTab getTab(int tabIndex) {
        return this.tabs.get(tabIndex);
    }

    public int getActiveTab() {
        return this.activeTab;
    }

    public void setActiveTab(int tabIndex) {
        this.activeTab = tabIndex;
        this.resetPagination();
        this.updateAndSearchRecipes();
    }

    public boolean isActiveTab(int tabIndex) {
        return tabIndex == this.activeTab;
    }

    public void onRecipeBookUpdated() {
        this.updateAndSearchRecipes();
    }

    private static /* synthetic */ boolean lambda$updateAndSearchRecipes$4(ObjectSet searchResult, RecipeCollection recipeCollection) {
        return !searchResult.contains((Object)recipeCollection);
    }

    record RecipeSelection(@Nullable BioForgingRecipe recipe, int tab, int index) {
        public static RecipeSelection EMPTY = new RecipeSelection(null, -1, -1);

        @Nullable
        public ResourceLocation getRecipeId() {
            return this.recipe != null ? this.recipe.m_6423_() : null;
        }
    }
}

