/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.veins;

import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlock;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.util.LevelUtil;
import com.github.elenterius.biomancy.util.random.CellularNoise;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

class MalignantFleshSpreaderConfig
extends MultifaceSpreader.DefaultSpreaderConfig {
    protected static final Set<Block> VALID_SOURCES = Set.of((Block)ModBlocks.MALIGNANT_FLESH_SLAB.get(), (Block)ModBlocks.MALIGNANT_FLESH_STAIRS.get(), (Block)ModBlocks.MALIGNANT_FLESH.get());

    public MalignantFleshSpreaderConfig(MultifaceBlock block) {
        super(block);
    }

    public boolean m_214107_(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof PrimordialCradleBlock || VALID_SOURCES.contains(block);
    }

    protected boolean m_213938_(BlockGetter level, BlockPos posA, BlockPos posB, Direction direction, BlockState state) {
        BlockState blockstate = level.m_8055_(posB.m_121945_(direction));
        if (!blockstate.m_60713_(Blocks.f_50110_)) {
            FluidState fluidState = state.m_60819_();
            if (!fluidState.m_76178_() && !fluidState.m_192917_((Fluid)Fluids.f_76193_)) {
                return false;
            }
            if (state.m_204336_(BlockTags.f_13076_)) {
                return false;
            }
            return state.m_247087_() || super.m_213938_(level, posA, posB, direction, state);
        }
        return super.m_213938_(level, posA, posB, direction, state);
    }

    public boolean m_213973_(BlockGetter level, BlockPos pos, MultifaceSpreader.SpreadPos spreadPos) {
        BlockState state = level.m_8055_(spreadPos.f_221717_());
        if (PrimordialEcosystem.MALIGNANT_UPGRADE_TARGETS.contains(state.m_60734_())) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CellularNoise cellularNoise = PrimordialEcosystem.getCellularNoise(serverLevel);
                float borderThreshold = cellularNoise.borderThreshold() - 0.005f;
                float n = cellularNoise.getValueAtCenter(pos);
                return n >= borderThreshold && !LevelUtil.isBlockNearby(serverLevel, spreadPos.f_221717_(), 4, blockState -> blockState.m_60713_((Block)ModBlocks.PRIMAL_BLOOM.get()));
            }
            return true;
        }
        return this.m_213938_(level, pos, spreadPos.f_221717_(), spreadPos.f_221718_(), state) && this.f_221681_.m_221571_(level, state, spreadPos.f_221717_(), spreadPos.f_221718_());
    }

    public boolean m_221701_(LevelAccessor level, MultifaceSpreader.SpreadPos spreadPos, BlockState state, boolean markForPostprocessing) {
        if (PrimordialEcosystem.MALIGNANT_UPGRADE_TARGETS.contains(state.m_60734_())) {
            if (level.m_213780_().m_188501_() < 0.25f) {
                return level.m_7731_(spreadPos.f_221717_(), ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_(), 2);
            }
            return false;
        }
        int neighbors = 0;
        for (Direction direction : Direction.values()) {
            for (int i = 1; i <= 2; ++i) {
                BlockPos neighborPos = spreadPos.f_221717_().m_5484_(direction, i);
                BlockState neighborState = level.m_8055_(neighborPos);
                neighbors += neighborState.m_60713_((Block)this.f_221681_) ? 1 : 0;
                Block belowNeighborBlock = level.m_8055_(neighborPos.m_7495_()).m_60734_();
                boolean reduceNeighbors = PrimordialEcosystem.SOLID_FLESH_BLOCKS.contains(belowNeighborBlock);
                if (!reduceNeighbors) continue;
                --neighbors;
            }
        }
        if (neighbors >= 4) {
            return false;
        }
        BlockState blockstate = this.m_214136_(state, (BlockGetter)level, spreadPos.f_221717_(), spreadPos.f_221718_());
        if (blockstate == null) {
            return false;
        }
        if (markForPostprocessing) {
            level.m_46865_(spreadPos.f_221717_()).m_8113_(spreadPos.f_221717_());
        }
        return level.m_7731_(spreadPos.f_221717_(), blockstate, 2);
    }
}

