/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.storagesac;

import com.github.elenterius.biomancy.block.base.SimpleContainerBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandlers;
import com.github.elenterius.biomancy.inventory.ItemHandlerUtil;
import com.github.elenterius.biomancy.menu.StorageSacMenu;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ItemStackCounter;
import com.github.elenterius.biomancy.util.PlayerInteractionPredicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class StorageSacBlockEntity
extends SimpleContainerBlockEntity
implements PlayerInteractionPredicate {
    public static final int SLOTS = 15;
    public static final String TOP5_BY_COUNT_KEY = "Top5ByCount";
    public static final String INVENTORY_KEY = "Inventory";
    private final InventoryHandler<?> inventory;
    protected final ItemStackCounter itemCounter = new ItemStackCounter();
    private List<ItemStackCounter.CountedItem> top5ItemsByCount = List.of();

    public StorageSacBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STORAGE_SAC.get(), pos, state);
        this.inventory = InventoryHandlers.denyItemWithFilledInventory(15, this::onInventoryChanged);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return StorageSacMenu.createServerMenu(containerId, playerInventory, this);
    }

    public InventoryHandler<?> getInventory() {
        return this.inventory;
    }

    @Override
    public Component getDefaultName() {
        return TextComponentUtil.getTranslationText("container", "sac");
    }

    public List<ItemStackCounter.CountedItem> getItemsForRendering() {
        return this.top5ItemsByCount;
    }

    protected void countAllItems() {
        this.itemCounter.clear();
        this.itemCounter.accountStacks((IItemHandler)this.inventory);
        this.top5ItemsByCount = this.itemCounter.getItemCountSorted(5, false);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    protected void onInventoryChanged() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.countAllItems();
        this.m_6596_();
        this.syncToClient();
    }

    protected void syncToClient() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 2);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(TOP5_BY_COUNT_KEY, (Tag)this.serializeTop5());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INVENTORY_KEY, (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(INVENTORY_KEY)) {
            this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_KEY));
            this.countAllItems();
        }
        if (tag.m_128441_(TOP5_BY_COUNT_KEY)) {
            this.top5ItemsByCount = this.deserializeTop5(tag.m_128469_(TOP5_BY_COUNT_KEY));
        }
    }

    public List<ItemStackCounter.CountedItem> deserializeTop5(CompoundTag store) {
        ArrayList<ItemStackCounter.CountedItem> items = new ArrayList<ItemStackCounter.CountedItem>();
        ListTag list = store.m_128437_("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (stack.m_41619_()) continue;
            int amount = itemTag.m_128451_("Amount");
            stack.m_41764_(Mth.m_14045_((int)amount, (int)1, (int)3));
            items.add(new ItemStackCounter.CountedItem(stack, amount));
        }
        return items;
    }

    public CompoundTag serializeTop5() {
        ListTag list = new ListTag();
        for (ItemStackCounter.CountedItem countedItem : this.top5ItemsByCount) {
            CompoundTag tag = new CompoundTag();
            countedItem.stack().m_41739_(tag);
            tag.m_128405_("Amount", countedItem.amount());
            list.add((Object)tag);
        }
        CompoundTag store = new CompoundTag();
        store.m_128365_("Items", (Tag)list);
        return store;
    }

    @Override
    public void dropContainerContents(Level level, BlockPos pos) {
        ItemHandlerUtil.dropContents(level, pos, this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ModCapabilities.ITEM_HANDLER) {
            return this.inventory.getLazyOptional().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventory.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.inventory.revive();
    }
}

