/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.ownable;

import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.util.ownable.Ownable;
import com.github.elenterius.biomancy.util.ownable.OwnableEntityBlock;
import com.github.elenterius.biomancy.util.permission.Actions;
import com.github.elenterius.biomancy.util.permission.IRestrictedInteraction;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public abstract class OwnableBlock
extends BaseEntityBlock
implements OwnableEntityBlock {
    protected OwnableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        OwnableEntityBlock.appendUserListToTooltip(stack, tooltip);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Ownable) {
            Ownable ownable = (Ownable)blockEntity;
            OwnableEntityBlock.setBlockEntityOwner(level, ownable, placer, stack);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack;
        Item item;
        IRestrictedInteraction restrictedBlock;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (restrictedBlock = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.USE_BLOCK) && (item = (stack = player.m_21120_(hand)).m_41720_()) instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (restrictedBlock.isActionAllowed(player, Actions.CONFIGURE)) {
                boolean success = essenceItem.getEntityUUID(stack).map(restrictedBlock::addUser).orElse(false);
                if (success) {
                    stack.m_41774_(1);
                    level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                    return InteractionResult.SUCCESS;
                }
            }
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        IRestrictedInteraction interaction;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (interaction = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.DESTROY_BLOCK)) {
            return super.m_5880_(state, player, level, pos);
        }
        return 0.0f;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }
}

