/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.membrane;

import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlockEntity;
import com.github.elenterius.biomancy.block.membrane.IgnoreEntityCollisionPredicate;
import com.github.elenterius.biomancy.block.membrane.MembraneBlock;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BiometricMembraneBlock
extends MembraneBlock
implements EntityBlock {
    public BiometricMembraneBlock(BlockBehaviour.Properties properties) {
        super(properties, IgnoreEntityCollisionPredicate.IS_VALID_FOR_BLOCK_ENTITY_MEMBRANE);
    }

    public static ItemStack createItem(@Nullable EntityType<?> entityType, @Nullable UUID entityUUID, int[] entityColors, boolean isInverted) {
        CompoundTag tag = new CompoundTag();
        if (entityUUID != null) {
            tag.m_128362_("entity_uuid", entityUUID);
        } else if (entityType != null) {
            tag.m_128359_("entity_type", EntityType.m_20613_(entityType).toString());
        }
        if (entityColors.length == 2 && (entityColors[0] != -1 || entityColors[1] != -1)) {
            tag.m_128385_("entity_colors", entityColors);
        }
        if (isInverted) {
            tag.m_128379_("is_inverted", true);
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("membrane", (Tag)tag);
        ItemStack stack = new ItemStack((ItemLike)ModItems.BIOMETRIC_MEMBRANE.get());
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.BIOMETRIC_MEMBRANE.get()), (CompoundTag)compoundTag);
        return stack;
    }

    public static int getTintColor(ItemStack stack, int tintIndex) {
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag == null || !compoundTag.m_128441_("membrane")) {
            return -1;
        }
        CompoundTag tag = compoundTag.m_128469_("membrane");
        if (tag.m_128425_("entity_colors", 11)) {
            return tag.m_128465_("entity_colors")[tintIndex];
        }
        return -1;
    }

    public static int getTintColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (level == null || pos == null) {
            return -1;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BiometricMembraneBlockEntity) {
            BiometricMembraneBlockEntity membrane = (BiometricMembraneBlockEntity)blockEntity;
            return membrane.getColors()[tintIndex];
        }
        return -1;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.BIOMETRIC_MEMBRANE.get()).m_155264_(pos, state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag == null || !compoundTag.m_128441_("membrane")) {
            return;
        }
        CompoundTag tag = compoundTag.m_128469_("membrane");
        if (tag.m_128403_("entity_uuid")) {
            UUID entityUUID = tag.m_128342_("entity_uuid");
            tooltip.add((Component)ComponentUtil.literal("UUID: " + entityUUID).m_130940_(ChatFormatting.GRAY));
        } else {
            Optional optional = EntityType.m_20632_((String)tag.m_128461_("entity_type"));
            optional.ifPresent(entityType -> tooltip.add((Component)ComponentUtil.literal("Type: ").m_7220_(entityType.m_20676_()).m_130940_(ChatFormatting.GRAY)));
        }
    }
}

