/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.fleshspike;

import com.github.elenterius.biomancy.block.fleshspike.FleshSpikeBlock;
import com.github.elenterius.biomancy.util.IntermediaryKeyCache;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class FleshSpikeShapes {
    static final IntermediaryKeyCache<BlockState, ComputedShapes> CACHE = new IntermediaryKeyCache(FleshSpikeShapes::computeKey);

    private FleshSpikeShapes() {
    }

    static void computePossibleShapes(List<BlockState> possibleStates) {
        possibleStates.forEach(possibleState -> CACHE.computeIfAbsent((BlockState)possibleState, FleshSpikeShapes::computeShapes));
    }

    static VoxelShape getDamageShape(BlockState blockState) {
        return CACHE.get(blockState).damageShape();
    }

    static VoxelShape getBoundingShape(BlockState blockState) {
        return CACHE.get(blockState).boundingShape();
    }

    public static VoxelShape getCollisionShape(BlockState blockState) {
        return CACHE.get(blockState).collisionShape();
    }

    private static Integer computeKey(BlockState blockState) {
        return Objects.hash(blockState.m_61143_((Property)FleshSpikeBlock.FACING), FleshSpikeBlock.getSpikes(blockState));
    }

    private static ComputedShapes computeShapes(BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)FleshSpikeBlock.FACING);
        int spikes = FleshSpikeBlock.getSpikes(blockState);
        VoxelShape boundingShape = FleshSpikeShapes.computeBoundingShape(direction, spikes);
        VoxelShape collisionShape = FleshSpikeShapes.computeCollisionShape(direction, spikes);
        VoxelShape damageShape = FleshSpikeShapes.computeDamageShape(direction, spikes);
        return new ComputedShapes(boundingShape, collisionShape, damageShape);
    }

    private static VoxelShape computeBoundingShape(Direction direction, int spikes) {
        if (spikes == 1) {
            return VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 0.0, 4.0, 12.0, 7.0, 12.0);
        }
        if (spikes == 2) {
            return VoxelShapeUtil.createXZRotatedTowards(direction, 2.0, 0.0, 2.0, 14.0, 8.0, 14.0);
        }
        if (spikes == 3) {
            return VoxelShapeUtil.createXZRotatedTowards(direction, 1.0, 0.0, 1.0, 15.0, 11.0, 15.0);
        }
        return Shapes.m_83040_();
    }

    private static VoxelShape computeCollisionShape(Direction direction, int spikes) {
        if (spikes == 1) {
            return VoxelShapeUtil.createXZRotatedTowards(direction, 6.0, 0.0, 6.0, 10.0, 2.0, 10.0);
        }
        if (spikes == 2) {
            return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 0.0, 6.0, 8.0, 2.0, 10.0), VoxelShapeUtil.createXZRotatedTowards(direction, 8.0, 0.0, 7.0, 12.0, 2.0, 11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
        }
        if (spikes == 3) {
            return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 3.0, 0.0, 2.0, 7.0, 2.0, 6.0), VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 0.0, 5.0, 11.0, 4.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 1.0, 0.0, 7.0, 5.0, 2.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 0.0, 11.0, 8.0, 2.0, 15.0), VoxelShapeUtil.createXZRotatedTowards(direction, 10.0, 0.0, 10.0, 14.0, 2.0, 14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
        }
        return Shapes.m_83040_();
    }

    private static VoxelShape computeDamageShape(Direction direction, int spikes) {
        if (spikes == 1) {
            return VoxelShapeUtil.createXZRotatedTowards(direction, 6.0, 2.0, 6.0, 10.0, 7.0, 10.0);
        }
        if (spikes == 2) {
            return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 2.0, 6.0, 8.0, 8.0, 10.0), VoxelShapeUtil.createXZRotatedTowards(direction, 8.0, 2.0, 7.0, 12.0, 7.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 7.0, 0.0, 4.0, 10.0, 2.0, 7.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
        }
        if (spikes == 3) {
            return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 3.0, 2.0, 2.0, 7.0, 6.0, 6.0), VoxelShapeUtil.createXZRotatedTowards(direction, 11.0, 2.0, 2.0, 15.0, 8.0, 6.0), VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 4.0, 5.0, 11.0, 11.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 1.0, 2.0, 7.0, 5.0, 8.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 2.0, 11.0, 8.0, 6.0, 15.0), VoxelShapeUtil.createXZRotatedTowards(direction, 10.0, 2.0, 10.0, 14.0, 6.0, 14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
        }
        return Shapes.m_83040_();
    }

    protected record ComputedShapes(VoxelShape boundingShape, VoxelShape collisionShape, VoxelShape damageShape) {
    }
}

