/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.fleshkinchest;

import com.github.elenterius.biomancy.block.ownable.OwnableContainerBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandlers;
import com.github.elenterius.biomancy.inventory.ItemHandlerUtil;
import com.github.elenterius.biomancy.menu.FleshkinChestMenu;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.animation.TriggerableAnimation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FleshkinChestBlockEntity
extends OwnableContainerBlockEntity
implements GeoBlockEntity {
    public static final int SLOTS = 42;
    private final InventoryHandler<?> inventory;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            FleshkinChestBlockEntity.this.playSound(level, pos, (SoundEvent)ModSoundEvents.FLESHKIN_CHEST_OPEN.get());
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            FleshkinChestBlockEntity.this.playSound(level, pos, (SoundEvent)ModSoundEvents.FLESHKIN_CHEST_CLOSE.get());
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int prevOpenCount, int openCount) {
            if (openCount != prevOpenCount) {
                level.m_7696_(FleshkinChestBlockEntity.this.f_58858_, state.m_60734_(), 1, openCount);
            }
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof FleshkinChestMenu) {
                FleshkinChestMenu menu = (FleshkinChestMenu)abstractContainerMenu;
                return menu.getInventory() == FleshkinChestBlockEntity.this.inventory;
            }
            return false;
        }
    };
    private boolean lidShouldBeOpen = false;
    private boolean lidIsOpen = false;

    public FleshkinChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FLESHKIN_CHEST.get(), pos, state);
        this.inventory = InventoryHandlers.standard(42, this::onInventoryChanged);
    }

    protected void onInventoryChanged() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public void startOpen(Player player) {
        if (this.m_58901_() || player.m_5833_()) {
            return;
        }
        this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    public void stopOpen(Player player) {
        if (this.m_58901_() || player.m_5833_()) {
            return;
        }
        this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    public void recheckOpen() {
        if (this.m_58901_()) {
            return;
        }
        this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.lidShouldBeOpen = type > 0;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void attack(Direction direction, @Nullable LivingEntity target) {
        Level level;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            if (target != null) {
                target.m_6469_(ModDamageSources.chestBite(this.f_58857_, pos), 4.0f);
            }
            this.attackAtPosition(serverLevel, pos.m_121945_(direction), target);
        }
    }

    protected void attackAtPosition(ServerLevel level, BlockPos pos, @Nullable LivingEntity excludedEntity) {
        this.broadcastAnimation(Animations.BITE);
        AABB aabb = new AABB(pos).m_82400_(0.25);
        List victims = level.m_6249_((Entity)excludedEntity, aabb, EntitySelector.f_20403_);
        for (Entity entity : victims) {
            entity.m_6469_(ModDamageSources.chestBite((Level)level, pos), 2.0f);
        }
    }

    private void playSound(Level level, BlockPos pos, SoundEvent sound) {
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    @Override
    public Component getDefaultName() {
        return TextComponentUtil.getTranslationText("container", "fleshkin_chest");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return FleshkinChestMenu.createServerMenu(containerId, playerInventory, this);
    }

    public InventoryHandler<?> getInventory() {
        return this.inventory;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    @Override
    public void dropContainerContents(Level level, BlockPos pos) {
        ItemHandlerUtil.dropContents(level, pos, this.inventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventory.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.inventory.revive();
    }

    protected void broadcastAnimation(TriggerableAnimation animation) {
        this.triggerAnim(animation.controller(), animation.name());
    }

    private <T extends FleshkinChestBlockEntity> PlayState handleAnimationState(AnimationState<T> state) {
        if (this.lidShouldBeOpen) {
            state.setAnimation(Animations.OPENING);
            this.lidIsOpen = true;
            return PlayState.CONTINUE;
        }
        if (this.lidIsOpen) {
            state.setAnimation(Animations.CLOSING);
            if (state.getController().getAnimationState() != AnimationController.State.STOPPED) {
                return PlayState.CONTINUE;
            }
            this.lidIsOpen = false;
        }
        if (!state.isCurrentAnimation(Animations.BITE.rawAnimation())) {
            state.getController().setAnimation(Animations.CLOSED);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnimationState);
        Animations.registerTriggerableAnimations(controller);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static final class Animations {
        private static final List<TriggerableAnimation> TRIGGERABLE_ANIMATIONS = new ArrayList<TriggerableAnimation>();
        static final String MAIN_CONTROLLER = "main";
        static final TriggerableAnimation BITE = Animations.register("main", "bite", RawAnimation.begin().thenPlay("fleshkin_chest.bite"));
        static final RawAnimation OPENING = RawAnimation.begin().thenPlay("fleshkin_chest.open").thenPlay("fleshkin_chest.opened");
        static final RawAnimation CLOSING = RawAnimation.begin().thenPlay("fleshkin_chest.close");
        static final RawAnimation CLOSED = RawAnimation.begin().thenPlay("fleshkin_chest.closed");

        private Animations() {
        }

        static TriggerableAnimation register(String controller, String name, RawAnimation rawAnimation) {
            TriggerableAnimation animation = new TriggerableAnimation(controller, name, rawAnimation);
            TRIGGERABLE_ANIMATIONS.add(animation);
            return animation;
        }

        static void registerTriggerableAnimations(AnimationController<?> controller) {
            for (TriggerableAnimation animation : TRIGGERABLE_ANIMATIONS) {
                if (!animation.controller().equals(controller.getName())) continue;
                controller.triggerableAnim(animation.name(), animation.rawAnimation());
            }
        }
    }
}

