/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.digester;

import com.github.elenterius.biomancy.api.nutrients.FuelHandler;
import com.github.elenterius.biomancy.api.nutrients.FuelHandlerImpl;
import com.github.elenterius.biomancy.block.base.MachineBlock;
import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.block.digester.DigesterStateData;
import com.github.elenterius.biomancy.client.util.ClientLoopingSoundHelper;
import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandlers;
import com.github.elenterius.biomancy.inventory.ItemHandlerUtil;
import com.github.elenterius.biomancy.menu.DigesterMenu;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ILoopingSoundHelper;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DigesterBlockEntity
extends MachineBlockEntity<DigestingRecipe, DigesterStateData>
implements MenuProvider,
GeoBlockEntity {
    public static final int FUEL_SLOTS = 1;
    public static final int INPUT_SLOTS = 1;
    public static final int OUTPUT_SLOTS = 2;
    public static final int MAX_FUEL = 1000;
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<DigestingRecipe>> RECIPE_TYPE = ModRecipes.DIGESTING_RECIPE_TYPE;
    protected static final RawAnimation WORKING_ANIM = RawAnimation.begin().thenLoop("digester.working");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("digester.idle");
    private final DigesterStateData stateData;
    private final FuelHandlerImpl fuelHandler;
    private final InventoryHandler<?> fuelInventory;
    private final InventoryHandler<?> inputInventory;
    private final InventoryHandler<?> outputInventory;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ILoopingSoundHelper loopingSoundHelper = ILoopingSoundHelper.NULL;
    private LazyOptional<IFluidHandler> optionalFluidConsumer;

    public DigesterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DIGESTER.get(), pos, state);
        this.inputInventory = InventoryHandlers.standard(1, () -> this.onInventoryChanged());
        this.outputInventory = InventoryHandlers.denyInput(2, () -> this.onInventoryChanged());
        this.fuelInventory = InventoryHandlers.filterFuel(1, () -> this.onInventoryChanged());
        this.fuelHandler = FuelHandlerImpl.createNutrientFuelHandler(1000, () -> this.onInventoryChanged());
        this.stateData = new DigesterStateData(this.fuelHandler);
        this.optionalFluidConsumer = LazyOptional.of(this.fuelHandler::getFluidConsumer);
    }

    public void onLoad() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loopingSoundHelper = new ClientLoopingSoundHelper();
        }
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return TextComponentUtil.getTranslationText("container", Objects.requireNonNull(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_())).m_135815_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return DigesterMenu.createServerMenu(containerId, playerInventory, this);
    }

    @Override
    public DigesterStateData getStateData() {
        return this.stateData;
    }

    @Override
    public InventoryHandler<?> getInputInventory() {
        return this.inputInventory;
    }

    public InventoryHandler<?> getFuelInventory() {
        return this.fuelInventory;
    }

    public InventoryHandler<?> getOutputInventory() {
        return this.outputInventory;
    }

    @Override
    protected FuelHandler getFuelHandler() {
        return this.fuelHandler;
    }

    @Override
    public ItemStack getStackInFuelSlot() {
        return this.fuelInventory.getStackInSlot(0);
    }

    @Override
    public void setStackInFuelSlot(ItemStack stack) {
        this.fuelInventory.setStackInSlot(0, stack);
    }

    @Override
    protected boolean doesRecipeResultFitIntoOutputInv(DigestingRecipe craftingGoal, ItemStack stackToCraft) {
        return ItemHandlerUtil.doesItemFit(this.outputInventory.getRaw(), stackToCraft);
    }

    @Override
    @Nullable
    protected DigestingRecipe resolveRecipeFromInput(Level level) {
        return ((SimpleRecipeType.ItemStackRecipeType)RECIPE_TYPE.get()).getRecipeFromContainer(level, (Container)this.inputInventory.getRecipeWrapper()).orElse(null);
    }

    @Override
    protected boolean doesRecipeMatchInput(DigestingRecipe recipeToTest, Level level) {
        return recipeToTest.m_5818_((Container)this.inputInventory.getRecipeWrapper(), level);
    }

    @Override
    protected boolean craftRecipe(DigestingRecipe recipeToCraft, Level level) {
        ItemStack result = recipeToCraft.m_5874_((Container)this.inputInventory.getRecipeWrapper(), level.m_9598_());
        if (!result.m_41619_() && this.doesRecipeResultFitIntoOutputInv(recipeToCraft, result)) {
            ItemStack craftingRemainder = this.getCraftingRemainder();
            this.inputInventory.extractItem(0, 1, false);
            ItemHandlerUtil.insertItem(this.outputInventory.getRaw(), result);
            if (!craftingRemainder.m_41619_()) {
                ItemHandlerUtil.insertItem(this.outputInventory.getRaw(), craftingRemainder);
            }
            SoundUtil.broadcastBlockSound((ServerLevel)level, this.m_58899_(), ModSoundEvents.DIGESTER_CRAFTING_COMPLETED);
            this.m_6596_();
            return true;
        }
        return false;
    }

    private ItemStack getCraftingRemainder() {
        ItemStack stack = this.inputInventory.getStackInSlot(0);
        if (stack.hasCraftingRemainingItem()) {
            return stack.getCraftingRemainingItem();
        }
        if (stack.m_41720_() instanceof BowlFoodItem) {
            return new ItemStack((ItemLike)Items.f_42399_);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getInputSlotStack() {
        return this.inputInventory.getStackInSlot(0);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.stateData.serialize(tag);
        tag.m_128365_("Fuel", (Tag)this.fuelHandler.serializeNBT());
        tag.m_128365_("FuelSlots", (Tag)this.fuelInventory.serializeNBT());
        tag.m_128365_("InputSlots", (Tag)this.inputInventory.serializeNBT());
        tag.m_128365_("OutputSlots", (Tag)this.outputInventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stateData.deserialize(tag);
        this.fuelHandler.deserializeNBT(tag.m_128469_("Fuel"));
        this.fuelInventory.deserializeNBT(tag.m_128469_("FuelSlots"));
        this.inputInventory.deserializeNBT(tag.m_128469_("InputSlots"));
        this.outputInventory.deserializeNBT(tag.m_128469_("OutputSlots"));
    }

    @Override
    public void dropAllInvContents(Level level, BlockPos pos) {
        ItemHandlerUtil.dropContents(level, pos, this.fuelInventory);
        ItemHandlerUtil.dropContents(level, pos, this.inputInventory);
        ItemHandlerUtil.dropContents(level, pos, this.outputInventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_) {
            return super.getCapability(cap, side);
        }
        if (cap == ModCapabilities.ITEM_HANDLER) {
            if (side == null || side == Direction.DOWN) {
                return this.outputInventory.getLazyOptional().cast();
            }
            if (side == Direction.UP) {
                return this.inputInventory.getLazyOptional().cast();
            }
            return this.fuelInventory.getLazyOptional().cast();
        }
        if (cap == ModCapabilities.FLUID_HANDLER) {
            return this.optionalFluidConsumer.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fuelInventory.invalidate();
        this.inputInventory.invalidate();
        this.outputInventory.invalidate();
        this.optionalFluidConsumer.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.fuelInventory.revive();
        this.inputInventory.revive();
        this.outputInventory.revive();
        this.optionalFluidConsumer = LazyOptional.of(this.fuelHandler::getFluidConsumer);
    }

    private <E extends DigesterBlockEntity> PlayState handleAnimationState(AnimationState<E> event) {
        Boolean isCrafting = (Boolean)this.m_58900_().m_61143_((Property)MachineBlock.CRAFTING);
        if (Boolean.TRUE.equals(isCrafting)) {
            event.getController().setAnimation(WORKING_ANIM);
            this.loopingSoundHelper.startLoop(this, (SoundEvent)ModSoundEvents.DIGESTER_CRAFTING.get(), 0.65f);
        } else {
            event.getController().setAnimation(IDLE_ANIM);
            this.loopingSoundHelper.stopLoop();
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::handleAnimationState)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7651_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loopingSoundHelper.clear();
        }
        super.m_7651_();
    }
}

